/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Service;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.ConfigurerStrategy;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.support.PluginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceBootstrapCloseable
implements BootstrapCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceBootstrapCloseable.class);
    private final CamelContext camelContext;
    private final ExtendedCamelContext camelContextExtension;

    public DefaultServiceBootstrapCloseable(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.camelContextExtension = camelContext.getCamelContextExtension();
    }

    @Override
    public void close() {
        FactoryFinder ff;
        ProcessorFactory pf;
        ConfigurerStrategy.clearBootstrapConfigurers();
        Set set = this.camelContextExtension.getServices().stream().filter(s -> s instanceof BootstrapCloseable).collect(Collectors.toSet());
        for (Service service : set) {
            try {
                if (service instanceof BootstrapCloseable) {
                    ((BootstrapCloseable)((Object)service)).close();
                }
                this.camelContext.removeService(service);
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        ConfigurerResolver cr = PluginHelper.getBootstrapConfigurerResolver(this.camelContextExtension);
        if (cr instanceof BootstrapCloseable) {
            try {
                ((BootstrapCloseable)((Object)cr)).close();
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        if ((pf = PluginHelper.getProcessorFactory(this.camelContextExtension)) instanceof BootstrapCloseable) {
            try {
                ((BootstrapCloseable)((Object)pf)).close();
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        if ((ff = this.camelContextExtension.getBootstrapFactoryFinder()) instanceof BootstrapCloseable) {
            try {
                ((BootstrapCloseable)((Object)ff)).close();
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap service. This exception is ignored", (Throwable)e);
            }
        }
        this.camelContextExtension.setBootstrapFactoryFinder(null);
    }
}

