/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteTemplateContainer;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;

@Metadata(label="routeTemplates")
@XmlRootElement(name="routeTemplates")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteTemplatesDefinition
extends OptionalIdentifiedDefinition<RouteTemplatesDefinition>
implements RouteTemplateContainer,
CamelContextAware,
ResourceAware {
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ErrorHandlerFactory errorHandlerFactory;
    @XmlTransient
    private Resource resource;
    @XmlElementRef
    private List<RouteTemplateDefinition> routeTemplates = new ArrayList<RouteTemplateDefinition>();

    public String toString() {
        return "RouteTemplates: " + String.valueOf(this.routeTemplates);
    }

    @Override
    public String getShortName() {
        return "routeTemplates";
    }

    @Override
    public String getLabel() {
        return "RouteTemplate " + this.getId();
    }

    @Override
    public List<RouteTemplateDefinition> getRouteTemplates() {
        return this.routeTemplates;
    }

    @Override
    public void setRouteTemplates(List<RouteTemplateDefinition> routeTemplates) {
        this.routeTemplates = routeTemplates;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public RouteTemplateDefinition routeTemplate(String id) {
        RouteTemplateDefinition routeTemplate = this.createRouteTemplate();
        routeTemplate.id(id);
        return this.routeTemplate(routeTemplate);
    }

    public RouteTemplateDefinition routeTemplate(RouteTemplateDefinition template) {
        this.getRouteTemplates().add(template);
        return template;
    }

    protected RouteTemplateDefinition createRouteTemplate() {
        RouteTemplateDefinition template = new RouteTemplateDefinition();
        ErrorHandlerFactory handler = this.getErrorHandlerFactory();
        if (handler != null) {
            template.getRoute().setErrorHandlerFactoryIfNull(handler);
        }
        if (this.resource != null) {
            template.setResource(this.resource);
        }
        return template;
    }
}

