/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import org.apache.camel.processor.resequencer.Element;
import org.apache.camel.processor.resequencer.ElementComparator;
import org.apache.camel.processor.resequencer.MessageRejectedException;
import org.apache.camel.processor.resequencer.Sequence;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.SequenceSender;
import org.apache.camel.processor.resequencer.Timeout;
import org.apache.camel.util.concurrent.ThreadHelper;

public class ResequencerEngine<E> {
    private Element<E> lastDelivered;
    private long timeout;
    private final Sequence<Element<E>> sequence;
    private Timer timer;
    private SequenceSender<E> sequenceSender;
    private Boolean rejectOld;
    private Map<CountDownLatch, Predicate<Sequence<?>>> waitConditions = new HashMap();

    public ResequencerEngine(SequenceElementComparator<E> comparator) {
        this.sequence = ResequencerEngine.createSequence(comparator);
        this.timeout = 2000L;
        this.lastDelivered = null;
    }

    public void start() {
        this.timer = new Timer(ThreadHelper.resolveThreadName("Camel Thread ${counter} - ${name}", "Stream Resequencer Timer"), true);
    }

    public void stop() {
        this.timer.cancel();
    }

    public synchronized int size() {
        return this.sequence.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntil(Predicate<Sequence<?>> pred) throws InterruptedException {
        CountDownLatch latch;
        ResequencerEngine resequencerEngine = this;
        synchronized (resequencerEngine) {
            if (pred.test(this.sequence)) {
                return;
            }
            latch = new CountDownLatch(1);
            this.waitConditions.put(latch, pred);
        }
        latch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateConditions() {
        ResequencerEngine resequencerEngine = this;
        synchronized (resequencerEngine) {
            Iterator<Map.Entry<CountDownLatch, Predicate<Sequence<?>>>> it = this.waitConditions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CountDownLatch, Predicate<Sequence<?>>> e = it.next();
                if (!e.getValue().test(this.sequence)) continue;
                e.getKey().countDown();
                it.remove();
            }
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Boolean getRejectOld() {
        return this.rejectOld;
    }

    public void setRejectOld(Boolean rejectOld) {
        this.rejectOld = rejectOld;
    }

    public SequenceSender<E> getSequenceSender() {
        return this.sequenceSender;
    }

    public void setSequenceSender(SequenceSender<E> sequenceSender) {
        this.sequenceSender = sequenceSender;
    }

    E getLastDelivered() {
        if (this.lastDelivered == null) {
            return null;
        }
        return this.lastDelivered.getObject();
    }

    void setLastDelivered(E o) {
        this.lastDelivered = new Element<E>(o);
    }

    public synchronized void insert(E o) {
        Element<E> element = new Element<E>(o);
        if (!this.sequence.seqComparator().isValid(element)) {
            throw new IllegalArgumentException("Element cannot be used in comparator: " + String.valueOf(this.sequence.seqComparator()));
        }
        if (this.rejectOld != null && this.rejectOld.booleanValue() && this.beforeLastDelivered(element)) {
            throw new MessageRejectedException("rejecting message [" + String.valueOf(element.getObject()) + "], it should have been sent before the last delivered message [" + String.valueOf(this.lastDelivered.getObject()) + "]");
        }
        this.sequence.add(element);
        Element<E> successor = this.sequence.successor(element);
        if (successor != null) {
            successor.cancel();
        }
        if (!this.successorOfLastDelivered(element) && this.sequence.predecessor(element) == null) {
            element.schedule(this.defineTimeout());
        }
        this.evaluateConditions();
    }

    public synchronized void deliver() throws Exception {
        while (this.deliverNext()) {
        }
    }

    public synchronized boolean deliverNext() throws Exception {
        if (this.sequence.isEmpty()) {
            return false;
        }
        Element element = (Element)this.sequence.first();
        if (element.scheduled()) {
            return false;
        }
        this.sequence.remove(element);
        this.lastDelivered = element;
        this.sequenceSender.sendElement(element.getObject());
        this.evaluateConditions();
        return true;
    }

    private boolean successorOfLastDelivered(Element<E> element) {
        if (this.lastDelivered == null) {
            return false;
        }
        return this.sequence.seqComparator().successor(element, this.lastDelivered);
    }

    private boolean beforeLastDelivered(Element<E> element) {
        if (this.lastDelivered == null) {
            return false;
        }
        return this.sequence.seqComparator().compare(element, this.lastDelivered) < 0;
    }

    private Timeout defineTimeout() {
        return new Timeout(this.timer, this.timeout);
    }

    private static <E> Sequence<Element<E>> createSequence(SequenceElementComparator<E> comparator) {
        return new Sequence<Element<E>>(new ElementComparator<E>(comparator));
    }
}

