/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.Exchange;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.service.lra.LRASagaStep;
import org.apache.camel.util.ObjectHelper;

public class LRASagaCoordinator
implements CamelSagaCoordinator {
    private LRASagaService sagaService;
    private URL lraURL;

    public LRASagaCoordinator(LRASagaService sagaService, URL lraURL) {
        this.sagaService = ObjectHelper.notNull(sagaService, "sagaService");
        this.lraURL = ObjectHelper.notNull(lraURL, "lraURL");
    }

    @Override
    public CompletableFuture<Void> beginStep(Exchange exchange, CamelSagaStep step) {
        LRASagaStep sagaStep;
        try {
            sagaStep = LRASagaStep.fromCamelSagaStep(step, exchange);
        }
        catch (RuntimeException ex) {
            return CompletableFuture.supplyAsync(() -> {
                throw ex;
            });
        }
        return this.sagaService.getClient().join(this.lraURL, sagaStep, exchange);
    }

    @Override
    public CompletableFuture<Void> compensate(Exchange exchange) {
        return this.sagaService.getClient().compensate(this.lraURL, exchange);
    }

    @Override
    public CompletableFuture<Void> complete(Exchange exchange) {
        return this.sagaService.getClient().complete(this.lraURL, exchange);
    }

    @Override
    public String getId() {
        return this.lraURL.toString();
    }
}

