/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.service.lra.LRASagaService;
import org.apache.camel.util.URISupport;

public class LRASagaRoutes
extends RouteBuilder {
    private LRASagaService sagaService;

    public LRASagaRoutes(LRASagaService sagaService) {
        this.sagaService = sagaService;
    }

    @Override
    public void configure() throws Exception {
        this.rest(this.sagaService.getLocalParticipantContextPath()).put("/compensate").to("direct:lra-compensation");
        ((ChoiceDefinition)((RouteDefinition)this.from("direct:lra-compensation").routeId("lra-compensation").process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Compensate").isNotNull()).toD("${header.Camel-Saga-Compensate}")).end();
        this.rest(this.sagaService.getLocalParticipantContextPath()).put("/complete").to("direct:lra-completion");
        ((ChoiceDefinition)((RouteDefinition)this.from("direct:lra-completion").routeId("lra-completion").process(this::verifyRequest)).choice().when(this.header("Camel-Saga-Complete").isNotNull()).toD("${header.Camel-Saga-Complete}")).end();
    }

    private void verifyRequest(Exchange exchange) {
        String completionURI;
        if (exchange.getIn().getHeader("Long-Running-Action") == null) {
            throw new IllegalArgumentException("Missing Long-Running-Action header in received request");
        }
        HashSet<String> usedURIs = new HashSet<String>();
        String compensationURI = exchange.getIn().getHeader("Camel-Saga-Compensate", String.class);
        if (compensationURI != null) {
            usedURIs.add(compensationURI);
        }
        if ((completionURI = exchange.getIn().getHeader("Camel-Saga-Complete", String.class)) != null) {
            usedURIs.add(completionURI);
        }
        if (usedURIs.isEmpty()) {
            try {
                Map<String, Object> queryParams = URISupport.parseQuery(exchange.getIn().getHeader("CamelHttpQuery", String.class));
                if (!queryParams.isEmpty()) {
                    if (queryParams.get("Camel-Saga-Compensate") != null) {
                        compensationURI = queryParams.get("Camel-Saga-Compensate").toString();
                        usedURIs.add(compensationURI);
                        exchange.getIn().setHeader("Camel-Saga-Compensate", compensationURI);
                    }
                    if (queryParams.get("Camel-Saga-Complete") != null) {
                        completionURI = queryParams.get("Camel-Saga-Complete").toString();
                        usedURIs.add(completionURI);
                        exchange.getIn().setHeader("Camel-Saga-Complete", completionURI);
                    }
                }
            }
            catch (URISyntaxException ex) {
                throw new RuntimeCamelException("URISyntaxException during CamelHttpQuery header parsing");
            }
        }
        for (String uri : usedURIs) {
            if (this.sagaService.getRegisteredURIs().contains(uri)) continue;
            throw new IllegalArgumentException("URI " + uri + " is not allowed");
        }
    }
}

