/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.LineNumberAware;
import org.apache.camel.NamedRoute;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;

public final class LoggerHelper {
    private LoggerHelper() {
    }

    public static String getLineNumberLoggerName(Object node) {
        Object name = null;
        if (node instanceof LineNumberAware) {
            if (node instanceof NamedRoute) {
                node = ((NamedRoute)node).getInput();
            }
            String loc = ((LineNumberAware)node).getLocation();
            int line = ((LineNumberAware)node).getLineNumber();
            if (loc != null) {
                name = loc;
                if (loc.contains(":")) {
                    loc = StringHelper.after(loc, ":", loc);
                    name = FileUtil.stripPath(loc);
                } else {
                    int pos = ((String)name).lastIndexOf(46);
                    if (pos > 0) {
                        name = ((String)name).substring(0, pos);
                    }
                }
                if (line != -1) {
                    name = (String)name + ":" + line;
                }
            }
        }
        return name;
    }

    public static String getSourceLocation(Object node) {
        Object name = null;
        if (node instanceof LineNumberAware) {
            if (node instanceof NamedRoute) {
                node = ((NamedRoute)node).getInput();
            }
            String loc = ((LineNumberAware)node).getLocation();
            int line = ((LineNumberAware)node).getLineNumber();
            if (loc != null) {
                name = loc;
                if (line != -1) {
                    name = (String)name + ":" + line;
                }
            }
        }
        return name;
    }

    public static String stripSourceLocationLineNumber(String location) {
        int cnt = StringHelper.countChar(location, ':');
        if (cnt > 1) {
            int pos = location.lastIndexOf(58);
            return location.substring(0, pos);
        }
        return location;
    }

    public static Integer extractSourceLocationLineNumber(String location) {
        int pos;
        int cnt = StringHelper.countChar(location, ':');
        if (cnt > 1 && (pos = location.lastIndexOf(58)) < location.length() - 1) {
            String num = location.substring(pos + 1);
            try {
                return Integer.valueOf(num);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

