/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.ProxyFactory;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class HttpClientHTTPConduit
extends URLConnectionHTTPConduit {
    private static final Set<String> RESTRICTED_HEADERS = HttpClientHTTPConduit.getRestrictedHeaders();
    volatile HttpClient client;
    volatile int lastTlsHash = -1;
    volatile URI sslURL;

    public HttpClientHTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(b, ei, t);
    }

    private static Set<String> getRestrictedHeaders() {
        TreeSet<String> headers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        headers.addAll(Set.of("Connection", "Content-Length", "Expect", "Host", "Upgrade"));
        return headers;
    }

    private boolean isSslTargetDifferent(URI lastURL, URI url) {
        return !lastURL.getScheme().equals(url.getScheme()) || !lastURL.getHost().equals(url.getHost()) || lastURL.getPort() != url.getPort();
    }

    @Override
    public void close(Message msg) throws IOException {
        super.close(msg);
        msg.remove(HttpClient.class);
    }

    @Override
    public void close() {
        if (this.client instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.client).close();
            }
            catch (Exception exception) {}
        } else if (this.client != null) {
            String name = this.client.toString();
            this.client = null;
            this.tryToShutdownSelector(name);
        }
        this.defaultAddress = null;
        super.close();
    }

    private synchronized void tryToShutdownSelector(String n) {
        int idx = ((String)n).lastIndexOf(40);
        if (idx > 0) {
            n = ((String)n).substring(idx + 1);
            n = ((String)n).substring(0, ((String)n).length() - 1);
            n = "HttpClient-" + (String)n + "-SelectorManager";
        }
        try {
            ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
            Thread[] threads = new Thread[rootGroup.activeCount()];
            int cnt = rootGroup.enumerate(threads);
            for (int x = 0; x < cnt; ++x) {
                if (!threads[x].getName().contains((CharSequence)n)) continue;
                threads[x].interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void setupConnection(Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        HttpClient cl;
        String httpRequestMethod;
        Object o;
        URI uri = address.getURI();
        message.put("http.scheme", uri.getScheme());
        TLSClientParameters clientParameters = message.get(TLSClientParameters.class);
        if (clientParameters == null) {
            clientParameters = this.tlsClientParameters;
        }
        if (clientParameters == null) {
            clientParameters = new TLSClientParameters();
        }
        if ((o = message.getContextualProperty("force.urlconnection.http.conduit")) == null) {
            o = message.get("USING_URLCONNECTION");
        }
        if ("https".equals(uri.getScheme()) && clientParameters != null) {
            if (clientParameters.getSSLSocketFactory() != null) {
                o = Boolean.TRUE;
            }
            if (clientParameters.isDisableCNCheck()) {
                if (clientParameters.getSslContext() != null) {
                    o = Boolean.TRUE;
                }
                if (clientParameters.getTrustManagers() != null && JavaUtils.getJavaMajorVersion() < 14) {
                    o = Boolean.TRUE;
                }
            }
        }
        if (Boolean.TRUE.equals(o)) {
            message.put("USING_URLCONNECTION", Boolean.TRUE);
            super.setupConnection(message, address, csPolicy);
            return;
        }
        if (this.sslURL != null && this.isSslTargetDifferent(this.sslURL, uri)) {
            this.sslURL = null;
            this.client = null;
        }
        if ((httpRequestMethod = (String)message.get("org.apache.cxf.request.method")) == null) {
            httpRequestMethod = "POST";
            message.put("org.apache.cxf.request.method", "POST");
        }
        if ((cl = this.client) == null) {
            String verc;
            int ctimeout = HttpClientHTTPConduit.determineConnectionTimeout(message, csPolicy);
            ProxyFactoryProxySelector ps = new ProxyFactoryProxySelector(this.proxyFactory, csPolicy);
            HttpClient.Builder cb = HttpClient.newBuilder().proxy(ps).followRedirects(HttpClient.Redirect.NEVER);
            if (ctimeout > 0) {
                cb.connectTimeout(Duration.ofMillis(ctimeout));
            }
            if ("https".equals(uri.getScheme())) {
                this.sslURL = uri;
                try {
                    SSLContext sslContext = clientParameters.getSslContext();
                    if (sslContext == null) {
                        sslContext = SSLUtils.getSSLContext(clientParameters, true);
                        cb.sslContext(sslContext);
                    }
                    if (sslContext != null) {
                        String[] supportedCiphers = org.apache.cxf.configuration.jsse.SSLUtils.getSupportedCipherSuites(sslContext);
                        String[] cipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude(clientParameters.getCipherSuites(), clientParameters.getCipherSuitesFilter(), sslContext.getSocketFactory().getDefaultCipherSuites(), supportedCiphers, LOG);
                        if (clientParameters.getSecureSocketProtocol() != null) {
                            String protocol = clientParameters.getSecureSocketProtocol();
                            SSLParameters params = new SSLParameters(cipherSuites, new String[]{protocol});
                            cb.sslParameters(params);
                        } else {
                            SSLParameters params = new SSLParameters(cipherSuites, TLSClientParameters.getPreferredClientProtocols());
                            cb.sslParameters(params);
                        }
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
            if ((verc = (String)message.getContextualProperty("org.apache.cxf.transport.http.forceVersion")) == null) {
                verc = csPolicy.getVersion();
            }
            if ("1.1".equals(HTTP_VERSION) || "1.1".equals(verc)) {
                cb.version(HttpClient.Version.HTTP_1_1);
            }
            cl = cb.build();
            if (!"https".equals(uri.getScheme()) && !KNOWN_HTTP_VERBS_WITH_NO_CONTENT.contains(httpRequestMethod) && cl.version() == HttpClient.Version.HTTP_2 && ("2".equals(verc) || "auto".equals(verc) && "2".equals(HTTP_VERSION))) {
                try {
                    HttpRequest.Builder rb = HttpRequest.newBuilder().uri(uri).method("OPTIONS", HttpRequest.BodyPublishers.noBody());
                    cl.send(rb.build(), HttpResponse.BodyHandlers.ofByteArray());
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
            this.client = cl;
        }
        message.put(HttpClient.class, cl);
        message.put("http.connection.address", address);
    }

    @Override
    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        Object o = message.get("USING_URLCONNECTION");
        if (Boolean.TRUE == o) {
            return super.createOutputStream(message, needToCacheRequest, isChunking, chunkThreshold);
        }
        return new HttpClientWrappedOutputStream(message, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName());
    }

    private static final class ProxyFactoryProxySelector
    extends ProxySelector {
        private final ProxyFactory proxyFactory;
        private final HTTPClientPolicy csPolicy;

        ProxyFactoryProxySelector(ProxyFactory proxyFactory, HTTPClientPolicy csPolicy) {
            this.proxyFactory = proxyFactory;
            this.csPolicy = csPolicy;
        }

        @Override
        public List<Proxy> select(final URI uri) {
            List<Proxy> listProxy;
            Proxy proxy = this.proxyFactory.createProxy(this.csPolicy, uri);
            if (proxy != null) {
                return Arrays.asList(proxy);
            }
            if (System.getSecurityManager() != null) {
                try {
                    listProxy = AccessController.doPrivileged(new PrivilegedExceptionAction<List<Proxy>>(){

                        @Override
                        public List<Proxy> run() throws IOException {
                            return ProxySelector.getDefault().select(uri);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                listProxy = ProxySelector.getDefault().select(uri);
            }
            return listProxy;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }

    class HttpClientWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream {
        List<Flow.Subscriber<? super ByteBuffer>> subscribers;
        CompletableFuture<HttpResponse<InputStream>> future;
        long contentLen;
        int rtimeout;
        volatile Throwable exception;
        volatile boolean connectionComplete;
        PipedOutputStream pout;
        HttpClientBodyPublisher publisher;
        HttpRequest request;

        HttpClientWrappedOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold, String conduitName) {
            super(message, needToCacheRequest, isChunking, chunkThreshold, conduitName, ((Address)message.get("http.connection.address")).getURI());
            this.subscribers = new LinkedList<Flow.Subscriber<? super ByteBuffer>>();
            this.contentLen = -1L;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.pout != null) {
                this.pout.close();
                this.pout = null;
            }
            if (this.publisher != null) {
                this.publisher.close();
                this.publisher = null;
            }
            this.request = null;
            this.subscribers = null;
        }

        void addSubscriber(Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.subscribers.add(subscriber);
        }

        @Override
        protected void setFixedLengthStreamingMode(int i) {
            this.contentLen = i;
        }

        @Override
        protected void handleNoOutput() throws IOException {
            this.contentLen = 0L;
            if (this.pout != null) {
                this.pout.close();
            }
            if (this.exception != null) {
                if (this.exception instanceof IOException) {
                    throw (IOException)this.exception;
                }
                throw new IOException(this.exception);
            }
        }

        public void setProtocolHeadersInBuilder(HttpRequest.Builder rb) throws IOException {
            boolean addHeaders = MessageUtils.getContextualBoolean(this.outMessage, "org.apache.cxf.http.add-headers", false);
            Headers h = new Headers(this.outMessage);
            boolean hasCT = false;
            for (Map.Entry<String, List<String>> head : h.headerMap().entrySet()) {
                List<String> headerList = head.getValue();
                String header = head.getKey();
                if (RESTRICTED_HEADERS.contains(header)) continue;
                if ("Content-Type".equalsIgnoreCase(header)) {
                    hasCT = true;
                    continue;
                }
                if (addHeaders || "Cookie".equalsIgnoreCase(header)) {
                    headerList.forEach(s -> rb.header(header, (String)s));
                    continue;
                }
                rb.header(header, String.join((CharSequence)",", headerList));
            }
            if (!h.headerMap().containsKey("User-Agent")) {
                rb.header("User-Agent", Headers.USER_AGENT);
            }
            if (hasCT || !HTTPConduit.KNOWN_HTTP_VERBS_WITH_NO_CONTENT.contains(this.outMessage.get("org.apache.cxf.request.method"))) {
                Object setCtForEmptyRequestProp;
                boolean dropContentType = false;
                boolean emptyRequest = PropertyUtils.isTrue(this.outMessage.get("org.apache.cxf.empty.request"));
                if (emptyRequest && (setCtForEmptyRequestProp = this.outMessage.getContextualProperty("set.content.type.for.empty.request")) != null) {
                    dropContentType = PropertyUtils.isFalse(setCtForEmptyRequestProp);
                }
                if (!dropContentType) {
                    rb.header("Content-Type", h.determineContentType());
                }
            }
        }

        private boolean isConnectionAttemptCompleted(HTTPClientPolicy csPolicy, PipedOutputStream out) throws IOException {
            if (!this.connectionComplete) {
                if (this.future.isDone()) {
                    block9: {
                        try {
                            this.future.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            if (!(e.getCause() instanceof IOException)) break block9;
                            throw new Fault("Could not send Message.", HTTPConduit.LOG, (Throwable)((IOException)e.getCause()));
                        }
                    }
                    return false;
                }
                try {
                    out.wait(csPolicy.getConnectionTimeout());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.future.isDone()) {
                    block10: {
                        try {
                            this.future.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            if (!(e.getCause() instanceof IOException)) break block10;
                            throw new Fault("Could not send Message.", HTTPConduit.LOG, (Throwable)((IOException)e.getCause()));
                        }
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        protected void setProtocolHeaders() throws IOException {
            final HttpClient cl = this.outMessage.get(HttpClient.class);
            Address address = (Address)this.outMessage.get("http.connection.address");
            HTTPClientPolicy csPolicy = HttpClientHTTPConduit.this.getClient(this.outMessage);
            String httpRequestMethod = (String)this.outMessage.get("org.apache.cxf.request.method");
            if (HTTPConduit.KNOWN_HTTP_VERBS_WITH_NO_CONTENT.contains(httpRequestMethod) || PropertyUtils.isTrue(this.outMessage.get("org.apache.cxf.empty.request"))) {
                this.contentLen = 0L;
            }
            PipedInputStream pin = new PipedInputStream(csPolicy.getChunkLength() <= 0 ? 4096 : csPolicy.getChunkLength());
            this.publisher = new HttpClientBodyPublisher(this, pin);
            if (this.contentLen != 0L) {
                this.pout = new HttpClientPipedOutputStream(this, pin, csPolicy, this.publisher);
            }
            HttpRequest.Builder rb = HttpRequest.newBuilder().method(httpRequestMethod, this.publisher);
            String verc = (String)this.outMessage.getContextualProperty("org.apache.cxf.transport.http.forceVersion");
            if (verc == null) {
                verc = csPolicy.getVersion();
            }
            if ("1.1".equals(HTTPConduit.HTTP_VERSION) || "1.1".equals(verc)) {
                rb.version(HttpClient.Version.HTTP_1_1);
            }
            try {
                rb.uri(address.getURI());
            }
            catch (IllegalArgumentException iae) {
                MalformedURLException mex = new MalformedURLException(iae.getMessage());
                mex.initCause(iae);
                throw mex;
            }
            this.rtimeout = HTTPConduit.determineReceiveTimeout(this.outMessage, csPolicy);
            if (this.rtimeout > 0) {
                rb.timeout(Duration.ofMillis(this.rtimeout));
            }
            this.setProtocolHeadersInBuilder(rb);
            this.request = rb.build();
            final HttpResponse.BodyHandler<InputStream> handler = HttpResponse.BodyHandlers.ofInputStream();
            if (System.getSecurityManager() != null) {
                try {
                    this.future = AccessController.doPrivileged(new PrivilegedExceptionAction<CompletableFuture<HttpResponse<InputStream>>>(){

                        @Override
                        public CompletableFuture<HttpResponse<InputStream>> run() throws IOException {
                            return cl.sendAsync(HttpClientWrappedOutputStream.this.request, handler);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.future = cl.sendAsync(this.request, handler);
            }
            this.future.exceptionally(ex -> {
                if (this.pout != null) {
                    PipedOutputStream pipedOutputStream = this.pout;
                    synchronized (pipedOutputStream) {
                        this.pout.notifyAll();
                    }
                }
                return null;
            });
        }

        @Override
        protected void setupWrappedStream() throws IOException {
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(this.pout);
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = this.pout;
            }
            if (this.exception != null) {
                if (this.exception instanceof IOException) {
                    throw (IOException)this.exception;
                }
                throw new IOException(this.exception);
            }
        }

        @Override
        protected String getExceptionMessage(Throwable t) {
            if (t instanceof ConnectException && t.getMessage() == null) {
                return "Connection refused";
            }
            return t.getMessage();
        }

        HttpResponse<InputStream> getResponse() throws IOException {
            try {
                if (this.rtimeout > 0) {
                    return this.future.get(this.rtimeout, TimeUnit.MILLISECONDS);
                }
                return this.future.get();
            }
            catch (ExecutionException e) {
                Throwable cause;
                Throwable t = e.getCause();
                if (t instanceof ConnectException && (cause = t.getCause()) instanceof UnresolvedAddressException) {
                    UnknownHostException uhe = new UnknownHostException();
                    uhe.initCause(cause);
                    throw uhe;
                }
                if (t instanceof IOException) {
                    IOException iot = (IOException)t;
                    throw iot;
                }
                throw new IOException(t);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (TimeoutException e) {
                throw (IOException)new HttpTimeoutException("Timeout").initCause(e);
            }
        }

        @Override
        protected int getResponseCode() throws IOException {
            return this.getResponse().statusCode();
        }

        @Override
        protected void updateResponseHeaders(Message inMessage) throws IOException {
            Headers h = new Headers(inMessage);
            HttpResponse<InputStream> rsp = this.getResponse();
            h.readFromConnection(rsp.headers().map());
            if (rsp.headers().map().containsKey("Content-Type")) {
                List<String> s = rsp.headers().allValues("Content-Type");
                inMessage.put("Content-Type", String.join((CharSequence)",", s));
            } else {
                inMessage.put("Content-Type", null);
            }
            HttpClientHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            HttpResponse<InputStream> resp = this.getResponse();
            String method = (String)this.outMessage.get("org.apache.cxf.request.method");
            int sc = resp.statusCode();
            if ("HEAD".equals(method)) {
                try (InputStream in = resp.body();){
                    InputStream inputStream = null;
                    return inputStream;
                }
            }
            if (sc == 204) {
                return null;
            }
            if ("OPTIONS".equals(method) || sc >= 300 && sc < 500) {
                Optional<String> f = resp.headers().firstValue("content-length");
                Optional<String> fChunk = resp.headers().firstValue("transfer-encoding");
                if (f.isPresent()) {
                    long l = Long.parseLong(f.get());
                    if (l == 0L) {
                        try (InputStream in = resp.body();){
                            InputStream inputStream = null;
                            return inputStream;
                        }
                    }
                } else if (!fChunk.isPresent() || !"chunked".equals(fChunk.get())) {
                    if (resp.version() == HttpClient.Version.HTTP_2) {
                        InputStream in = resp.body();
                        if (in.available() <= 0) {
                            try (InputStream inputStream = in;){
                                InputStream inputStream2 = null;
                                return inputStream2;
                            }
                        }
                    } else {
                        try (InputStream in = resp.body();){
                            InputStream inputStream = null;
                            return inputStream;
                        }
                    }
                }
            }
            return new HttpClientFilteredInputStream(resp.body());
        }

        @Override
        protected void closeInputStream() throws IOException {
            InputStream is = this.getInputStream();
            if (is != null) {
                is.close();
            }
        }

        @Override
        protected void handleResponseAsync() throws IOException {
            this.handleResponseOnWorkqueue(true, false);
        }

        @Override
        public void thresholdReached() throws IOException {
            if (this.exception != null) {
                if (this.exception instanceof IOException) {
                    throw (IOException)this.exception;
                }
                throw new IOException(this.exception);
            }
        }

        @Override
        protected String getResponseMessage() throws IOException {
            try {
                HttpResponse<InputStream> in = this.getResponse();
                switch (in.statusCode()) {
                    case 404: {
                        return "Not Found";
                    }
                    case 405: {
                        return "Method Not Allowed";
                    }
                    case 503: {
                        return "Service Unavailable";
                    }
                    case 200: {
                        return "OK";
                    }
                }
                return in.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            Address addrss = (Address)this.outMessage.get("http.connection.address");
            URI uri = addrss.getURI();
            if ("http".equals(uri.getScheme())) {
                return null;
            }
            String method = (String)this.outMessage.get("org.apache.cxf.request.method");
            HttpClient cl = this.outMessage.get(HttpClient.class);
            while (!this.connectionComplete || !cl.sslContext().getClientSessionContext().getIds().hasMoreElements()) {
                Thread.yield();
            }
            byte[] key = cl.sslContext().getClientSessionContext().getIds().nextElement();
            SSLSession session = cl.sslContext().getClientSessionContext().getSession(key);
            Certificate[] localCerts = session.getLocalCertificates();
            String cipherSuite = session.getCipherSuite();
            Principal principal = session.getLocalPrincipal();
            Certificate[] serverCerts = session.getPeerCertificates();
            Principal peer = session.getPeerPrincipal();
            HttpsURLConnectionInfo info = new HttpsURLConnectionInfo(uri, method, cipherSuite, localCerts, principal, serverCerts, peer);
            return info;
        }

        @Override
        protected boolean usingProxy() {
            HttpClient cl = this.outMessage.get(HttpClient.class);
            return cl.proxy().isPresent();
        }

        @Override
        protected InputStream getPartialResponse() throws IOException {
            HttpResponse<InputStream> rsp = this.getResponse();
            int responseCode = rsp.statusCode();
            if (responseCode == 202 || responseCode == 200) {
                try {
                    PushbackInputStream pbin = new PushbackInputStream(rsp.body());
                    int c = pbin.read();
                    if (c != -1) {
                        pbin.unread((byte)c);
                        return pbin;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected void setupNewConnection(String newURL) throws IOException {
            Address address;
            this.connectionComplete = false;
            HTTPClientPolicy cp = HttpClientHTTPConduit.this.getClient(this.outMessage);
            try {
                address = HttpClientHTTPConduit.this.defaultAddress.getString().equals(newURL) ? HttpClientHTTPConduit.this.defaultAddress : new Address(newURL);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            HttpClientHTTPConduit.this.setupConnection(this.outMessage, address, cp);
            this.url = address.getURI();
        }

        @Override
        protected void retransmitStream() throws IOException {
            this.cachedStream.writeCacheTo(this.pout);
            if (this.pout != null) {
                this.pout.close();
            }
        }

        @Override
        protected void updateCookiesBeforeRetransmit() throws IOException {
            Headers h = new Headers();
            HttpResponse<InputStream> rsp = this.getResponse();
            h.readFromConnection(rsp.headers().map());
            HttpClientHTTPConduit.this.cookies.readFromHeaders(h);
        }
    }

    private static final class HttpClientBodyPublisher
    implements HttpRequest.BodyPublisher {
        PipedInputStream pin;
        HttpClientWrappedOutputStream stream;
        long contentLen;

        private HttpClientBodyPublisher(HttpClientWrappedOutputStream s, PipedInputStream pin) {
            this.stream = s;
            this.pin = pin;
        }

        synchronized void close() {
            if (this.stream != null) {
                this.contentLen = this.stream.contentLen;
                this.stream = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            if (this.stream != null) {
                this.stream.connectionComplete = true;
                this.contentLen = this.stream.contentLen;
                if (this.stream.pout != null) {
                    PipedOutputStream pipedOutputStream = this.stream.pout;
                    synchronized (pipedOutputStream) {
                        this.stream.pout.notifyAll();
                    }
                    if (this.stream != null) {
                        this.contentLen = this.stream.contentLen;
                    }
                    HttpRequest.BodyPublishers.ofInputStream(new InputStreamSupplier(this.pin)).subscribe(subscriber);
                    this.stream = null;
                    this.pin = null;
                    return;
                }
            }
            HttpRequest.BodyPublishers.noBody().subscribe(subscriber);
        }

        @Override
        public long contentLength() {
            if (this.stream != null) {
                this.contentLen = this.stream.contentLen;
            }
            return this.contentLen;
        }
    }

    private static final class InputStreamSupplier
    implements Supplier<InputStream> {
        final InputStream in;

        InputStreamSupplier(InputStream i) {
            this.in = i;
        }

        @Override
        public InputStream get() {
            return this.in;
        }
    }

    private static final class HttpClientFilteredInputStream
    extends FilterInputStream {
        boolean closed;

        private HttpClientFilteredInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            return super.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                super.close();
                this.in = null;
            }
        }
    }

    static class HttpClientPipedOutputStream
    extends PipedOutputStream {
        HttpClientWrappedOutputStream stream;
        HTTPClientPolicy csPolicy;
        HttpClientBodyPublisher publisher;

        HttpClientPipedOutputStream(HttpClientWrappedOutputStream s, PipedInputStream pin, HTTPClientPolicy cp, HttpClientBodyPublisher bp) throws IOException {
            super(pin);
            this.stream = s;
            this.csPolicy = cp;
            this.publisher = bp;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.csPolicy = null;
            this.stream = null;
            if (this.publisher != null) {
                this.publisher.close();
                this.publisher = null;
            }
        }

        synchronized boolean canWrite() throws IOException {
            return this.stream.isConnectionAttemptCompleted(this.csPolicy, this);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.stream != null && (this.stream.connectionComplete || this.canWrite())) {
                super.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.stream != null && (this.stream.connectionComplete || this.canWrite())) {
                super.write(b, off, len);
            }
        }
    }
}

