/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import org.apache.camel.resume.OffsetKey;

public final class OffsetKeys {
    private OffsetKeys() {
    }

    public static <T> OffsetKey<T> of(T object) {
        return new AnonymousOffsetKey<T>(object);
    }

    public static <T> OffsetKey<T> unmodifiableOf(T object) {
        return new UnmodifiableOffsetKey<T>(object);
    }

    public static OffsetKey<?> empty() {
        return new AnonymousOffsetKey();
    }

    private static class AnonymousOffsetKey<T>
    implements OffsetKey<T> {
        private T key;

        public AnonymousOffsetKey() {
        }

        public AnonymousOffsetKey(T key) {
            this.key = key;
        }

        @Override
        public void setValue(T key) {
            this.key = key;
        }

        @Override
        public T getValue() {
            return this.key;
        }
    }

    private static class UnmodifiableOffsetKey<T>
    implements OffsetKey<T> {
        private final T key;

        public UnmodifiableOffsetKey(T key) {
            this.key = key;
        }

        @Override
        public void setValue(T key) {
            throw new UnsupportedOperationException("This object is unmodifiable");
        }

        @Override
        public T getValue() {
            return this.key;
        }
    }
}

