/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.saga;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.saga.SagaEndpoint;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultAsyncProducer;

public class SagaProducer
extends DefaultAsyncProducer {
    private final boolean success;
    private CamelSagaService camelSagaService;

    public SagaProducer(SagaEndpoint endpoint, boolean success) {
        super(endpoint);
        this.success = success;
        CamelSagaService sagaService = endpoint.getCamelContext().hasService(CamelSagaService.class);
        if (sagaService == null) {
            sagaService = CamelContextHelper.mandatoryFindSingleByType(endpoint.getCamelContext(), CamelSagaService.class);
        }
        this.camelSagaService = sagaService;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        String currentSaga = exchange.getIn().getHeader("Long-Running-Action", String.class);
        if (currentSaga == null) {
            exchange.setException(new IllegalStateException("Current exchange is not bound to a saga context: cannot complete"));
            callback.done(true);
            return true;
        }
        ((CompletableFuture)((CompletableFuture)this.camelSagaService.getSaga(currentSaga).thenApply(coordinator -> {
            if (coordinator == null) {
                throw new IllegalStateException("No coordinator found for saga id " + currentSaga);
            }
            return coordinator;
        })).thenCompose(coordinator -> {
            if (this.success) {
                return coordinator.complete(exchange);
            }
            return coordinator.compensate(exchange);
        })).whenComplete((res, ex) -> {
            if (ex != null) {
                exchange.setException((Throwable)ex);
            }
            callback.done(false);
        });
        return false;
    }
}

