/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.service.lra;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.saga.CamelSagaStep;

public final class LRASagaStep {
    private Optional<Endpoint> compensation;
    private Optional<Endpoint> completion;
    private Map<String, String> options;
    private Optional<Long> timeoutInMilliseconds;

    private LRASagaStep() {
    }

    public static LRASagaStep fromCamelSagaStep(CamelSagaStep step, Exchange exchange) {
        LRASagaStep t = new LRASagaStep();
        t.compensation = step.getCompensation();
        t.completion = step.getCompletion();
        t.timeoutInMilliseconds = step.getTimeoutInMilliseconds();
        t.options = new TreeMap<String, String>();
        for (Map.Entry<String, Expression> entry : step.getOptions().entrySet()) {
            try {
                t.options.put(entry.getKey(), entry.getValue().evaluate(exchange, String.class));
            }
            catch (Exception ex) {
                throw new RuntimeCamelException("Cannot evaluate saga option '" + entry.getKey() + "'", ex);
            }
        }
        return t;
    }

    public Optional<Endpoint> getCompensation() {
        return this.compensation;
    }

    public Optional<Endpoint> getCompletion() {
        return this.completion;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Optional<Long> getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public String toString() {
        return "LRASagaStep{compensation=" + String.valueOf(this.compensation) + ", completion=" + String.valueOf(this.completion) + ", options=" + String.valueOf(this.options) + ", timeoutInMilliseconds=" + String.valueOf(this.timeoutInMilliseconds) + "}";
    }
}

