/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategyParameterInfo;

public class AggregationStrategyMethodInfo {
    private final Method method;
    private final List<AggregationStrategyParameterInfo> oldParameters;
    private final List<AggregationStrategyParameterInfo> newParameters;

    public AggregationStrategyMethodInfo(Method method, List<AggregationStrategyParameterInfo> oldParameters, List<AggregationStrategyParameterInfo> newParameters) {
        this.method = method;
        this.oldParameters = oldParameters;
        this.newParameters = newParameters;
    }

    public Object invoke(Object pojo, Exchange oldExchange, Exchange newExchange) throws Exception {
        Object value;
        ArrayList list = new ArrayList(this.oldParameters.size() + this.newParameters.size());
        for (AggregationStrategyParameterInfo info : this.oldParameters) {
            if (oldExchange != null) {
                value = info.getExpression().evaluate(oldExchange, info.getType());
                list.add(value);
                continue;
            }
            list.add(null);
        }
        for (AggregationStrategyParameterInfo info : this.newParameters) {
            if (newExchange != null) {
                value = info.getExpression().evaluate(newExchange, info.getType());
                list.add(value);
                continue;
            }
            list.add(null);
        }
        Object[] args = list.toArray();
        return this.method.invoke(pojo, args);
    }
}

