/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

final class DelegatingDataSource
implements DataSource {
    private final DataSource delegate;
    private final String name;

    public DelegatingDataSource(String name, DataSource delegate) {
        this.name = StringHelper.notEmpty(name, "name");
        this.delegate = ObjectHelper.notNull(delegate, "DataSource");
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }
}

