/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mapstruct;

import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.mapstruct.MapStructMapperFinder;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ReflectionHelper;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMapStructFinder
extends ServiceSupport
implements MapStructMapperFinder,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMapStructFinder.class);
    private CamelContext camelContext;
    private String mapperPackageName;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getMapperPackageName() {
        return this.mapperPackageName;
    }

    @Override
    public int discoverMappings(Class<?> clazz) {
        AtomicInteger answer = new AtomicInteger();
        try {
            Object mapper = Mappers.getMapper(clazz);
            if (mapper != null) {
                ReflectionHelper.doWithMethods(mapper.getClass(), mc -> {
                    if (!Modifier.isPublic(mc.getModifiers())) {
                        return;
                    }
                    if (mc.isDefault()) {
                        return;
                    }
                    int parameterCount = mc.getParameterCount();
                    if (parameterCount != 1) {
                        return;
                    }
                    Class<?> from = mc.getParameterTypes()[0];
                    Class<?> to = mc.getReturnType();
                    if (to.isPrimitive()) {
                        return;
                    }
                    this.camelContext.getTypeConverterRegistry().addTypeConverter(to, from, new SimpleTypeConverter(false, (type, exchange, value) -> ObjectHelper.invokeMethod(mc, mapper, value)));
                    LOG.debug("Added MapStruct type converter: {} -> {}", from, to);
                    answer.incrementAndGet();
                });
            }
        }
        catch (Exception e) {
            LOG.debug("Mapper class: {} is not a MapStruct Mapper. Skipping this class.", clazz);
        }
        return answer.get();
    }

    @Override
    public void setMapperPackageName(String mapperPackageName) {
        this.mapperPackageName = mapperPackageName;
    }

    @Override
    protected void doInit() throws Exception {
        if (this.mapperPackageName != null) {
            String[] names = this.mapperPackageName.split(",");
            ExtendedCamelContext ecc = this.camelContext.getCamelContextExtension();
            Set<Class<?>> set = PluginHelper.getPackageScanClassResolver(ecc).findByFilter(f -> f.getName().endsWith("Mapper"), names);
            if (!set.isEmpty()) {
                int converters = 0;
                for (Class<?> clazz : set) {
                    converters += this.discoverMappings(clazz);
                }
                LOG.info("Discovered {} MapStruct type converters from classpath scanning: {}", (Object)converters, (Object)this.mapperPackageName);
            }
        }
    }
}

