/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerEventNotifierService;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.service.ServiceHelper;

public abstract class AbstractMicrometerEventNotifier<T extends CamelEvent>
extends EventNotifierSupport
implements CamelContextAware {
    private final Class<T> eventType;
    private CamelContext camelContext;
    private MeterRegistry meterRegistry;
    private boolean prettyPrint;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;

    protected AbstractMicrometerEventNotifier(Class<T> eventType) {
        this.eventType = eventType;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    @Override
    public boolean isEnabled(CamelEvent eventObject) {
        return this.eventType.isAssignableFrom(eventObject.getClass());
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.meterRegistry == null) {
            this.meterRegistry = MicrometerUtils.getOrCreateMeterRegistry(this.camelContext.getRegistry(), "metricsRegistry");
        }
        try {
            MicrometerEventNotifierService registryService = this.camelContext.hasService(MicrometerEventNotifierService.class);
            if (registryService == null) {
                registryService = new MicrometerEventNotifierService();
                registryService.setMeterRegistry(this.getMeterRegistry());
                registryService.setPrettyPrint(this.isPrettyPrint());
                registryService.setDurationUnit(this.getDurationUnit());
                registryService.setMatchingTags(Tags.of("kind", "CamelExchangeEvent"));
                this.camelContext.addService(registryService);
                ServiceHelper.startService(registryService);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }
}

