/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.routepolicy;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyConfiguration;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyFactory;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyService;
import org.apache.camel.component.micrometer.routepolicy.RouteMetric;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class MicrometerRoutePolicy
extends RoutePolicySupport
implements NonManagedService {
    private final MicrometerRoutePolicyFactory factory;
    private MeterRegistry meterRegistry;
    private boolean prettyPrint;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MicrometerRoutePolicyNamingStrategy namingStrategy = MicrometerRoutePolicyNamingStrategy.DEFAULT;
    private MicrometerRoutePolicyConfiguration configuration = MicrometerRoutePolicyConfiguration.DEFAULT;
    private final Map<Route, MetricsStatistics> statisticsMap = new HashMap<Route, MetricsStatistics>();
    private RouteMetric contextStatistic;
    boolean registerKamelets;
    boolean registerTemplates = true;

    public MicrometerRoutePolicy() {
        this.factory = null;
    }

    public MicrometerRoutePolicy(MicrometerRoutePolicyFactory factory) {
        this.factory = factory;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public MicrometerRoutePolicyNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerRoutePolicyNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public MicrometerRoutePolicyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MicrometerRoutePolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void onInit(Route route) {
        super.onInit(route);
        ManagementStrategy ms = route.getCamelContext().getManagementStrategy();
        if (ms != null && ms.getManagementAgent() != null) {
            this.registerKamelets = ms.getManagementAgent().getRegisterRoutesCreateByKamelet();
            this.registerTemplates = ms.getManagementAgent().getRegisterRoutesCreateByTemplate();
        }
        if (this.getMeterRegistry() == null) {
            this.setMeterRegistry(MicrometerUtils.getOrCreateMeterRegistry(route.getCamelContext().getRegistry(), "metricsRegistry"));
        }
        try {
            MicrometerRoutePolicyService registryService = route.getCamelContext().hasService(MicrometerRoutePolicyService.class);
            if (registryService == null) {
                registryService = new MicrometerRoutePolicyService();
                registryService.setMeterRegistry(this.getMeterRegistry());
                registryService.setPrettyPrint(this.isPrettyPrint());
                registryService.setDurationUnit(this.getDurationUnit());
                registryService.setMatchingTags(Tags.of("kind", "CamelRoute"));
                route.getCamelContext().addService(registryService);
                ServiceHelper.startService(registryService);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        if (this.factory != null && this.configuration.isContextEnabled() && this.contextStatistic == null) {
            this.contextStatistic = this.factory.createOrGetContextMetric(this);
        }
    }

    boolean isRegisterKamelets() {
        return this.registerKamelets;
    }

    boolean isRegisterTemplates() {
        return this.registerTemplates;
    }

    @Override
    public void onStart(Route route) {
        this.statisticsMap.computeIfAbsent(route, it -> {
            boolean skip;
            boolean bl = skip = !this.configuration.isRouteEnabled();
            if (!skip) {
                boolean bl2 = skip = it.isCreatedByKamelet() && !this.registerKamelets || it.isCreatedByRouteTemplate() && !this.registerTemplates;
            }
            if (skip) {
                return null;
            }
            return new MetricsStatistics(this.getMeterRegistry(), it.getCamelContext(), (Route)it, this.getNamingStrategy(), this.configuration);
        });
    }

    @Override
    public void onRemove(Route route) {
        MetricsStatistics stats = this.statisticsMap.remove(route);
        if (stats != null) {
            stats.remove();
        }
    }

    @Override
    public void onExchangeBegin(Route route, Exchange exchange) {
        if (this.contextStatistic != null) {
            this.contextStatistic.onExchangeBegin(exchange);
        }
        Optional.ofNullable(this.statisticsMap.get(route)).ifPresent(statistics -> statistics.onExchangeBegin(exchange));
    }

    @Override
    public void onExchangeDone(Route route, Exchange exchange) {
        if (this.contextStatistic != null) {
            this.contextStatistic.onExchangeDone(exchange);
        }
        Optional.ofNullable(this.statisticsMap.get(route)).ifPresent(statistics -> statistics.onExchangeDone(exchange));
    }

    static class MetricsStatistics
    implements RouteMetric {
        private final MeterRegistry meterRegistry;
        private final CamelContext camelContext;
        private final Route route;
        private final MicrometerRoutePolicyNamingStrategy namingStrategy;
        private final MicrometerRoutePolicyConfiguration configuration;
        private Counter exchangesSucceeded;
        private Counter exchangesFailed;
        private Counter exchangesTotal;
        private Counter externalRedeliveries;
        private Counter failuresHandled;
        private Timer timer;
        private LongTaskTimer longTaskTimer;

        MetricsStatistics(MeterRegistry meterRegistry, CamelContext camelContext, Route route, MicrometerRoutePolicyNamingStrategy namingStrategy, MicrometerRoutePolicyConfiguration configuration) {
            this.configuration = ObjectHelper.notNull(configuration, "MicrometerRoutePolicyConfiguration", this);
            this.meterRegistry = ObjectHelper.notNull(meterRegistry, "MeterRegistry", this);
            this.namingStrategy = ObjectHelper.notNull(namingStrategy, "MicrometerRoutePolicyNamingStrategy", this);
            this.camelContext = camelContext;
            this.route = route;
            if (configuration.isAdditionalCounters()) {
                this.initAdditionalCounters();
            }
        }

        private void initAdditionalCounters() {
            if (this.configuration.isExchangesSucceeded()) {
                this.exchangesSucceeded = this.createCounter(this.namingStrategy.getExchangesSucceededName(this.route), "Number of successfully completed exchanges");
            }
            if (this.configuration.isExchangesFailed()) {
                this.exchangesFailed = this.createCounter(this.namingStrategy.getExchangesFailedName(this.route), "Number of failed exchanges");
            }
            if (this.configuration.isExchangesTotal()) {
                this.exchangesTotal = this.createCounter(this.namingStrategy.getExchangesTotalName(this.route), "Total number of processed exchanges");
            }
            if (this.configuration.isExternalRedeliveries()) {
                this.externalRedeliveries = this.createCounter(this.namingStrategy.getExternalRedeliveriesName(this.route), "Number of external initiated redeliveries (such as from JMS broker)");
            }
            if (this.configuration.isFailuresHandled()) {
                this.failuresHandled = this.createCounter(this.namingStrategy.getFailuresHandledName(this.route), "Number of failures handled");
            }
            if (this.configuration.isLongTask()) {
                LongTaskTimer.Builder builder = LongTaskTimer.builder(this.namingStrategy.getLongTaskName(this.route)).tags(this.route != null ? this.namingStrategy.getTags(this.route) : this.namingStrategy.getTags(this.camelContext)).description(this.route != null ? "Route long task metric" : "CamelContext long task metric");
                if (this.configuration.getLongTaskInitiator() != null) {
                    this.configuration.getLongTaskInitiator().accept(builder);
                }
                this.longTaskTimer = builder.register(this.meterRegistry);
            }
        }

        @Override
        public void onExchangeBegin(Exchange exchange) {
            Timer.Sample sample = Timer.start(this.meterRegistry);
            exchange.setProperty(this.propertyName(exchange), (Object)sample);
            if (this.longTaskTimer != null) {
                exchange.setProperty(this.propertyName(exchange) + "_long_task", (Object)this.longTaskTimer.start());
            }
        }

        @Override
        public void onExchangeDone(Exchange exchange) {
            LongTaskTimer.Sample ltSampler;
            Timer.Sample sample = (Timer.Sample)exchange.removeProperty(this.propertyName(exchange));
            if (sample != null) {
                if (this.timer == null) {
                    Timer.Builder builder = ((Timer.Builder)Timer.builder(this.namingStrategy.getName(this.route)).tags((Iterable)(this.route != null ? this.namingStrategy.getTags(this.route) : this.namingStrategy.getTags(this.camelContext)))).description(this.route != null ? "Route performance metrics" : "CamelContext performance metrics");
                    if (this.configuration.getTimerInitiator() != null) {
                        this.configuration.getTimerInitiator().accept(builder);
                    }
                    this.timer = builder.register(this.meterRegistry);
                }
                sample.stop(this.timer);
            }
            if ((ltSampler = (LongTaskTimer.Sample)exchange.removeProperty(this.propertyName(exchange) + "_long_task")) != null) {
                ltSampler.stop();
            }
            if (this.configuration.isAdditionalCounters()) {
                this.updateAdditionalCounters(exchange);
            }
        }

        @Override
        public void remove() {
            if (this.exchangesSucceeded != null) {
                this.meterRegistry.remove(this.exchangesSucceeded);
            }
            if (this.exchangesFailed != null) {
                this.meterRegistry.remove(this.exchangesFailed);
            }
            if (this.exchangesTotal != null) {
                this.meterRegistry.remove(this.exchangesTotal);
            }
            if (this.externalRedeliveries != null) {
                this.meterRegistry.remove(this.externalRedeliveries);
            }
            if (this.failuresHandled != null) {
                this.meterRegistry.remove(this.failuresHandled);
            }
            if (this.timer != null) {
                this.meterRegistry.remove(this.timer);
            }
            if (this.longTaskTimer != null) {
                this.meterRegistry.remove(this.longTaskTimer);
            }
        }

        private void updateAdditionalCounters(Exchange exchange) {
            if (this.exchangesTotal != null) {
                this.exchangesTotal.increment();
            }
            if (exchange.isFailed()) {
                if (this.exchangesFailed != null) {
                    this.exchangesFailed.increment();
                }
            } else {
                if (this.exchangesSucceeded != null) {
                    this.exchangesSucceeded.increment();
                }
                if (this.failuresHandled != null && ExchangeHelper.isFailureHandled(exchange)) {
                    this.failuresHandled.increment();
                }
                if (this.externalRedeliveries != null && exchange.isExternalRedelivered()) {
                    this.externalRedeliveries.increment();
                }
            }
        }

        private String propertyName(Exchange exchange) {
            Object id = this.route != null ? this.route.getId() : "context:" + this.camelContext.getName();
            return String.format("%s-%s-%s", "camel.route.policy", id, exchange.getExchangeId());
        }

        private Counter createCounter(String meterName, String description) {
            return Counter.builder(meterName).tags(this.route != null ? this.namingStrategy.getExchangeStatusTags(this.route) : this.namingStrategy.getExchangeStatusTags(this.camelContext)).description(description).register(this.meterRegistry);
        }
    }
}

