/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.NoSuchVariableException;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ConstantExpressionAdapter;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.GroupIterator;
import org.apache.camel.support.GroupTokenIterator;
import org.apache.camel.support.LanguageHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.support.builder.PredicateBuilder;
import org.apache.camel.support.builder.TokenPairExpressionIterator;
import org.apache.camel.support.builder.TokenXMLExpressionIterator;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.Jsoner;
import org.apache.camel.util.xml.pretty.XmlPrettyPrinter;

public class ExpressionBuilder {
    public static Expression headerExpression(String headerName) {
        return ExpressionBuilder.headerExpression(ExpressionBuilder.simpleExpression(headerName));
    }

    public static Expression headerExpression(String headerName, boolean mandatory) {
        return ExpressionBuilder.headerExpression(ExpressionBuilder.simpleExpression(headerName), mandatory);
    }

    public static Expression headerExpression(Expression headerName) {
        return ExpressionBuilder.headerExpression(headerName, false);
    }

    public static Expression headerExpression(final Expression headerName, final boolean mandatory) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String key = headerName.evaluate(exchange, String.class);
                Object answer = exchange.getIn().getHeader(key);
                if (answer == null) {
                    answer = exchange.getProperty(key);
                }
                if (mandatory && answer == null) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(new NoSuchHeaderException(exchange, key, null));
                }
                return answer;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                headerName.init(context);
            }

            public String toString() {
                return "header(" + String.valueOf(headerName) + ")";
            }
        };
    }

    public static <T> Expression headerExpression(String headerName, Class<T> type) {
        return ExpressionBuilder.headerExpression(ExpressionBuilder.simpleExpression(headerName), ExpressionBuilder.constantExpression(type.getName()));
    }

    public static Expression headerExpression(String headerName, String typeName) {
        return ExpressionBuilder.headerExpression(ExpressionBuilder.simpleExpression(headerName), ExpressionBuilder.simpleExpression(typeName));
    }

    public static Expression headerExpression(final Expression headerName, final Expression typeName) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text;
                try {
                    text = typeName.evaluate(exchange, String.class);
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                text = headerName.evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(text, type);
                if (header == null) {
                    header = exchange.getProperty(text, type);
                }
                return header;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                headerName.init(context);
                typeName.init(context);
                this.classResolver = context.getClassResolver();
            }

            public String toString() {
                return "headerAs(" + String.valueOf(headerName) + ", " + String.valueOf(typeName) + ")";
            }
        };
    }

    public static Expression variableExpression(String variableName) {
        return ExpressionBuilder.variableExpression(ExpressionBuilder.simpleExpression(variableName));
    }

    public static Expression variableExpression(String variableName, boolean mandatory) {
        return ExpressionBuilder.variableExpression(ExpressionBuilder.simpleExpression(variableName), mandatory);
    }

    public static Expression variableExpression(Expression variableName) {
        return ExpressionBuilder.variableExpression(variableName, false);
    }

    public static Expression variableExpression(final Expression variableName, final boolean mandatory) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String key = variableName.evaluate(exchange, String.class);
                Object answer = ExchangeHelper.getVariable(exchange, key);
                if (mandatory && answer == null) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(new NoSuchVariableException(exchange, key));
                }
                return answer;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                variableName.init(context);
            }

            public String toString() {
                return "variable(" + String.valueOf(variableName) + ")";
            }
        };
    }

    public static <T> Expression variableExpression(String variableName, Class<T> type) {
        return ExpressionBuilder.variableExpression(ExpressionBuilder.simpleExpression(variableName), ExpressionBuilder.constantExpression(type.getName()));
    }

    public static Expression variableExpression(String variableName, String typeName) {
        return ExpressionBuilder.variableExpression(ExpressionBuilder.simpleExpression(variableName), ExpressionBuilder.simpleExpression(typeName));
    }

    public static Expression variableExpression(final Expression variableName, final Expression typeName) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private TypeConverter converter;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                try {
                    String text = typeName.evaluate(exchange, String.class);
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                String key = variableName.evaluate(exchange, String.class);
                Object value = ExchangeHelper.getVariable(exchange, key);
                if (value != null) {
                    value = this.converter.convertTo(type, value);
                }
                return value;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                variableName.init(context);
                typeName.init(context);
                this.classResolver = context.getClassResolver();
                this.converter = context.getTypeConverter();
            }

            public String toString() {
                return "variableAs(" + String.valueOf(variableName) + ", " + String.valueOf(typeName) + ")";
            }
        };
    }

    public static Expression headersExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeaders();
            }

            public String toString() {
                return "headers";
            }
        };
    }

    public static Expression variablesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getVariables();
            }

            public String toString() {
                return "variables";
            }
        };
    }

    public static Expression exchangePatternExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getPattern();
            }

            public String toString() {
                return "exchangePattern";
            }
        };
    }

    public static Expression exchangeExceptionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return LanguageHelper.exception(exchange);
            }

            public String toString() {
                return "exchangeException";
            }
        };
    }

    public static Expression exchangeExceptionExpression(final Class<Exception> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = (Exception)exchange.getException(type);
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                    return ObjectHelper.getException(type, exception);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException[" + String.valueOf(type) + "]";
            }
        };
    }

    public static Expression typeConverterExpression() {
        return new ExpressionAdapter(){
            private TypeConverter typeConverter;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.typeConverter;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.typeConverter = context.getTypeConverter();
            }

            public String toString() {
                return "typeConverter";
            }
        };
    }

    public static Expression registryExpression() {
        return new ExpressionAdapter(){
            private Registry registry;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.registry;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.registry = context.getRegistry();
            }

            public String toString() {
                return "registry";
            }
        };
    }

    public static Expression refExpression(String ref) {
        if (LanguageSupport.hasSimpleFunction(ref)) {
            return ExpressionBuilder.refExpression(ExpressionBuilder.simpleExpression(ref));
        }
        return ExpressionBuilder.refExpression(ExpressionBuilder.constantExpression(ref));
    }

    public static Expression refExpression(final Expression ref) {
        return new ExpressionAdapter(){
            private Registry registry;

            @Override
            public Object evaluate(Exchange exchange) {
                String text = ref.evaluate(exchange, String.class);
                if (text != null) {
                    return this.registry.lookupByName(text);
                }
                return null;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                ref.init(context);
                this.registry = context.getRegistry();
            }

            public String toString() {
                return "ref(" + String.valueOf(ref) + ")";
            }
        };
    }

    public static Expression camelContextExpression() {
        return new ExpressionAdapter(){
            private CamelContext context;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.context;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.context = context;
            }

            public String toString() {
                return "camelContext";
            }
        };
    }

    public static Expression camelContextNameExpression() {
        return new ConstantExpressionAdapter(){
            private String name;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.name;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.name = context.getName();
                this.setValue(this.name);
            }

            public String toString() {
                return "camelContextName";
            }
        };
    }

    public static Expression exchangeExceptionMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                }
                return exception != null ? exception.getMessage() : null;
            }

            public String toString() {
                return "exchangeExceptionMessage";
            }
        };
    }

    public static Expression exchangeExceptionStackTraceExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return LanguageHelper.exceptionStacktrace(exchange);
            }

            public String toString() {
                return "exchangeExceptionStackTrace";
            }
        };
    }

    public static Expression exchangePropertyExpression(String propertyName) {
        return ExpressionBuilder.exchangePropertyExpression(ExpressionBuilder.simpleExpression(propertyName));
    }

    public static Expression exchangePropertyExpression(String propertyName, boolean mandatory) {
        return ExpressionBuilder.exchangePropertyExpression(ExpressionBuilder.simpleExpression(propertyName), mandatory);
    }

    public static Expression exchangePropertyExpression(Expression propertyName) {
        return ExpressionBuilder.exchangePropertyExpression(propertyName, false);
    }

    public static Expression exchangePropertyExpression(final Expression propertyName, final boolean mandatory) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String key = propertyName.evaluate(exchange, String.class);
                Object answer = exchange.getProperty(key);
                if (mandatory && answer == null) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(new NoSuchPropertyException(exchange, key));
                }
                return answer;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                propertyName.init(context);
            }

            public String toString() {
                return "exchangeProperty(" + String.valueOf(propertyName) + ")";
            }
        };
    }

    public static Expression exchangePropertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperties();
            }

            public String toString() {
                return "exchangeProperties";
            }
        };
    }

    public static Expression camelContextPropertiesExpression() {
        return new ExpressionAdapter(){
            private Map<String, String> globalOptions;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.globalOptions;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.globalOptions = context.getGlobalOptions();
            }

            public String toString() {
                return "camelContextProperties";
            }
        };
    }

    public static Expression camelContextPropertyExpression(String propertyName) {
        return ExpressionBuilder.camelContextPropertyExpression(ExpressionBuilder.simpleExpression(propertyName));
    }

    public static Expression camelContextPropertyExpression(final Expression propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = propertyName.evaluate(exchange, String.class);
                return exchange.getContext().getGlobalOption(text);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                propertyName.init(context);
            }

            public String toString() {
                return "camelContextProperty(" + String.valueOf(propertyName) + ")";
            }
        };
    }

    public static Expression systemPropertyExpression(String propertyName) {
        return ExpressionBuilder.systemPropertyExpression(propertyName, null);
    }

    public static Expression systemPropertyExpression(String propertyName, String defaultValue) {
        Expression exprName = ExpressionBuilder.simpleExpression(propertyName);
        Expression exprDefault = ExpressionBuilder.simpleExpression(defaultValue);
        return ExpressionBuilder.systemPropertyExpression(exprName, exprDefault);
    }

    public static Expression systemPropertyExpression(final Expression exprName, final Expression defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = exprName.evaluate(exchange, String.class);
                String text2 = defaultValue.evaluate(exchange, String.class);
                return System.getProperty(text, text2);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                exprName.init(context);
                defaultValue.init(context);
            }

            public String toString() {
                return "systemProperty(" + String.valueOf(exprName) + ")";
            }
        };
    }

    public static Expression systemEnvironmentExpression(String propertyName) {
        return ExpressionBuilder.systemEnvironmentExpression(propertyName, null);
    }

    public static Expression systemEnvironmentExpression(String propertyName, String defaultValue) {
        Expression exprName = ExpressionBuilder.simpleExpression(propertyName);
        Expression expDefault = ExpressionBuilder.simpleExpression(defaultValue);
        return ExpressionBuilder.systemEnvironmentExpression(exprName, expDefault);
    }

    public static Expression systemEnvironmentExpression(final Expression propertyName, final Expression defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = propertyName.evaluate(exchange, String.class);
                String answer = LanguageHelper.sysenv(text);
                if (answer == null) {
                    answer = defaultValue.evaluate(exchange, String.class);
                }
                return answer;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                propertyName.init(context);
                defaultValue.init(context);
            }

            public String toString() {
                return "systemEnvironment(" + String.valueOf(propertyName) + ")";
            }
        };
    }

    public static Expression constantExpression(final Object value) {
        return new ConstantExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return value;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.setValue(value);
            }

            public String toString() {
                return String.valueOf(value);
            }
        };
    }

    public static Expression languageExpression(final String languageName, final Language language, final String expression) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.exp = language.createExpression(expression);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return languageName + "(" + expression + ")";
            }
        };
    }

    public static Expression languageExpression(final String language, final String expression) {
        return new ExpressionAdapter(){
            private Expression expr;
            private Predicate pred;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.expr.evaluate(exchange, Object.class);
            }

            @Override
            public boolean matches(Exchange exchange) {
                return this.pred.matches(exchange);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                Language lan = context.resolveLanguage(language);
                if (lan == null) {
                    throw new NoSuchLanguageException(language);
                }
                this.pred = lan.createPredicate(expression);
                this.pred.init(context);
                this.expr = lan.createExpression(expression);
                this.expr.init(context);
            }

            public String toString() {
                return "language[" + language + ":" + expression + "]";
            }
        };
    }

    public static Expression singleInputLanguageExpression(final String language, final String expression, final String source) {
        return new ExpressionAdapter(){
            private Expression expr;
            private Predicate pred;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.expr.evaluate(exchange, Object.class);
            }

            @Override
            public boolean matches(Exchange exchange) {
                return this.pred.matches(exchange);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                Language lan = context.resolveLanguage(language);
                if (lan != null) {
                    if (source != null && lan instanceof SingleInputTypedLanguageSupport) {
                        SingleInputTypedLanguageSupport sil = (SingleInputTypedLanguageSupport)lan;
                        Expression input = ExpressionBuilder.singleInputExpression(source);
                        this.expr = sil.createExpression(input, expression, null);
                        this.expr.init(context);
                        this.pred = PredicateBuilder.toPredicate(this.expr);
                        this.pred.init(context);
                    } else {
                        this.pred = lan.createPredicate(expression);
                        this.pred.init(context);
                        this.expr = lan.createExpression(expression);
                        this.expr.init(context);
                    }
                } else {
                    throw new NoSuchLanguageException(language);
                }
            }

            public String toString() {
                return "language[" + language + ":" + expression + "]";
            }
        };
    }

    public static Expression bodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static Expression originalBodyExpression() {
        return new ExpressionAdapter(){
            private boolean enabled;

            @Override
            public Object evaluate(Exchange exchange) {
                Message msg;
                UnitOfWork uow;
                if (this.enabled && (uow = exchange.getUnitOfWork()) != null && (msg = uow.getOriginalInMessage()) != null) {
                    return msg.getBody();
                }
                return null;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.enabled = context.isAllowUseOriginalMessage();
            }

            public String toString() {
                return "originalBody";
            }
        };
    }

    public static Expression bodyExpression(final Function<Object, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static Expression bodyExpression(final BiFunction<Object, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final Function<T, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType));
            }

            public String toString() {
                return "bodyExpression (" + String.valueOf(bodyType) + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final BiFunction<T, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression (" + String.valueOf(bodyType) + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyExpression(String name) {
        return ExpressionBuilder.bodyExpression(ExpressionBuilder.simpleExpression(name));
    }

    public static Expression bodyExpression(final Expression name) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                try {
                    String text = name.evaluate(exchange, String.class);
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                return exchange.getIn().getBody(type);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                name.init(context);
                this.classResolver = context.getClassResolver();
            }

            public String toString() {
                return "bodyAs[" + String.valueOf(name) + "]";
            }
        };
    }

    public static Expression singleInputExpression(String source) {
        Expression exp;
        if (source == null || source.isEmpty()) {
            exp = ExpressionBuilder.bodyExpression();
        } else if (source.startsWith("header:")) {
            exp = ExpressionBuilder.headerExpression(source.substring(7), true);
        } else if (source.startsWith("property:")) {
            exp = ExpressionBuilder.exchangePropertyExpression(source.substring(9), true);
        } else {
            if (source.startsWith("variable:")) {
                source = source.substring(9);
            }
            exp = ExpressionBuilder.variableExpression(source);
        }
        return exp;
    }

    public static Expression threadIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return Thread.currentThread().getId();
            }

            public String toString() {
                return "threadId";
            }
        };
    }

    public static Expression threadNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return Thread.currentThread().getName();
            }

            public String toString() {
                return "threadName";
            }
        };
    }

    public static Expression hostnameExpression() {
        return new ConstantExpressionAdapter(){
            private String hostname;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.hostname;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.hostname = InetAddressUtil.getLocalHostNameSafe();
                this.setValue(this.hostname);
            }

            public String toString() {
                return "hostname";
            }
        };
    }

    public static Expression stepIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperty(ExchangePropertyKey.STEP_ID);
            }

            public String toString() {
                return "stepId";
            }
        };
    }

    public static <T> Expression mandatoryBodyExpression(Class<T> type) {
        return ExpressionBuilder.mandatoryBodyExpression(type, false);
    }

    public static <T> Expression mandatoryBodyExpression(final Class<T> type, final boolean nullBodyAllowed) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (nullBodyAllowed && exchange.getIn().getBody() == null) {
                    return null;
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyTypeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                return body != null ? body.getClass() : null;
            }

            public String toString() {
                return "bodyType";
            }
        };
    }

    public static Expression exchangeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static Expression exchangeExpression(final Function<Exchange, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange);
            }

            public String toString() {
                return "exchangeExpression";
            }
        };
    }

    public static Expression messageExpression() {
        return ExpressionBuilder.inMessageExpression();
    }

    public static Expression messageExpression(String name) {
        return ExpressionBuilder.messageExpression(ExpressionBuilder.simpleExpression(name));
    }

    public static Expression messageExpression(final Expression name) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                try {
                    String text = name.evaluate(exchange, String.class);
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                return exchange.getMessage(type);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                name.init(context);
                this.classResolver = context.getClassResolver();
            }

            public String toString() {
                return "messageAs[" + String.valueOf(name) + "]";
            }
        };
    }

    public static Expression messageExpression(Function<Message, Object> function) {
        return ExpressionBuilder.inMessageExpression(function);
    }

    public static Expression inMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static Expression inMessageExpression(final Function<Message, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn());
            }

            public String toString() {
                return "inMessageExpression";
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Class<?> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (type != null) {
                    return expression.evaluate(exchange, type);
                }
                return expression;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
            }

            public String toString() {
                return String.valueOf(expression);
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Expression type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object result = type.evaluate(exchange, Object.class);
                if (result != null) {
                    return expression.evaluate(exchange, result.getClass());
                }
                return expression;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
                type.init(context);
            }

            public String toString() {
                return String.valueOf(expression);
            }
        };
    }

    public static Expression tokenizeExpression(Expression expression, String token) {
        return ExpressionBuilder.tokenizeExpression(expression, ExpressionBuilder.simpleExpression(token));
    }

    public static Expression tokenizeExpression(final Expression expression, final Expression token) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = token.evaluate(exchange, String.class);
                Object value = expression.evaluate(exchange, Object.class);
                return ExchangeHelper.getScanner(exchange, value, text);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
                token.init(context);
            }

            public String toString() {
                return "tokenize(" + String.valueOf(expression) + ", " + String.valueOf(token) + ")";
            }
        };
    }

    public static Expression skipFirstExpression(final Expression expression) {
        return new ExpressionAdapter(){
            private TypeConverter typeConverter;

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Iterator it = this.typeConverter.tryConvertTo(Iterator.class, exchange, value);
                if (it != null) {
                    it.next();
                    return it;
                }
                return value;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
                this.typeConverter = context.getTypeConverter();
            }

            public String toString() {
                return "skipFirst(" + String.valueOf(expression) + ")";
            }
        };
    }

    public static Expression regexTokenizeExpression(final Expression expression, final String regexTokenizer) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                return ExchangeHelper.getScanner(exchange, value, regexTokenizer);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
            }

            public String toString() {
                return "regexTokenize(" + String.valueOf(expression) + ", " + regexTokenizer + ")";
            }
        };
    }

    public static Expression groupXmlIteratorExpression(final Expression expression, final String group) {
        return new ExpressionAdapter(){
            private Expression groupExp;

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + String.valueOf(expression) + " evaluated on " + String.valueOf(exchange) + " must return an java.util.Iterator");
                Integer parts = this.groupExp.evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                return new GroupTokenIterator(exchange, it, null, parts, false);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
                this.groupExp = context.resolveLanguage("simple").createExpression(group);
                this.groupExp.init(context);
            }

            public String toString() {
                return "group " + String.valueOf(expression) + " " + group + " times";
            }
        };
    }

    public static Expression groupIteratorExpression(final Expression expression, final String token, final String group, final boolean skipFirst) {
        return new ExpressionAdapter(){
            private Expression groupExp;

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + String.valueOf(expression) + " evaluated on " + String.valueOf(exchange) + " must return an java.util.Iterator");
                Integer parts = this.groupExp.evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                if (token != null) {
                    return new GroupTokenIterator(exchange, it, token, parts, skipFirst);
                }
                return new GroupIterator(it, parts);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
                this.groupExp = context.resolveLanguage("simple").createExpression(group);
                this.groupExp.init(context);
            }

            public String toString() {
                return "group " + String.valueOf(expression) + " " + group + " times";
            }
        };
    }

    public static Expression joinExpression(final Expression expression, final String separator, final String prefix) {
        return new ExpressionAdapter(){
            private TypeConverter converter;

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + String.valueOf(expression) + " evaluated on " + String.valueOf(exchange) + " must return an java.util.Iterator");
                StringBuilder sb = new StringBuilder(128);
                while (it.hasNext()) {
                    String s;
                    Object o = it.next();
                    if (o == null || (s = this.converter.tryConvertTo(String.class, exchange, o)) == null) continue;
                    if (!sb.isEmpty()) {
                        sb.append(separator);
                    }
                    if (prefix != null) {
                        sb.append(prefix);
                    }
                    sb.append(s);
                }
                return sb.toString();
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
                this.converter = context.getTypeConverter();
            }

            public String toString() {
                if (prefix != null) {
                    return "join(" + String.valueOf(expression) + "," + separator + "," + prefix + ")";
                }
                return "join(" + String.valueOf(expression) + "," + separator + ")";
            }
        };
    }

    public static Expression sortExpression(final Expression expression, final Comparator comparator) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                List list = expression.evaluate(exchange, List.class);
                list.sort(comparator);
                return list;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
            }

            public String toString() {
                return "sort(" + String.valueOf(expression) + " by: " + String.valueOf(comparator) + ")";
            }
        };
    }

    public static Expression substring(final Expression expression, final int head, final int tail) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return StringHelper.between(text, head, tail);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
            }

            public String toString() {
                return "substring(" + String.valueOf(expression) + ", " + head + ", " + tail + ")";
            }
        };
    }

    public static Expression replaceAll(final Expression expression, final String from, final String to) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return text.replace(from, to);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
            }

            public String toString() {
                return "replaceAll(" + String.valueOf(expression) + ", " + from + ", " + to + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
            }

            public String toString() {
                return "regexReplaceAll(" + String.valueOf(expression) + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final Expression replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = expression.evaluate(exchange, String.class);
                String replacement = replacementExpression.evaluate(exchange, String.class);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                expression.init(context);
                replacementExpression.init(context);
            }

            public String toString() {
                return "regexReplaceAll(" + String.valueOf(expression) + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression append(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return left.evaluate(exchange, String.class) + right.evaluate(exchange, String.class);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                left.init(context);
                right.init(context);
            }

            public String toString() {
                return "append(" + String.valueOf(left) + ", " + String.valueOf(right) + ")";
            }
        };
    }

    public static Expression prepend(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return right.evaluate(exchange, String.class) + left.evaluate(exchange, String.class);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                left.init(context);
                right.init(context);
            }

            public String toString() {
                return "prepend(" + String.valueOf(left) + ", " + String.valueOf(right) + ")";
            }
        };
    }

    public static Expression concatExpression(Collection<Expression> expressions) {
        return ExpressionBuilder.concatExpression(expressions, null);
    }

    public static Expression concatExpression(Collection<Expression> expressions, String description) {
        for (Expression expression : expressions) {
            if (!(expression instanceof ConstantExpressionAdapter)) continue;
            return ExpressionBuilder.concatExpressionOptimized(expressions, description);
        }
        return ExpressionBuilder.concatExpressionUnoptimized(expressions, description);
    }

    private static Expression concatExpressionUnoptimized(final Collection<Expression> expressions, final String description) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                StringBuilder buffer = new StringBuilder(256);
                for (Expression expression : expressions) {
                    String text = expression.evaluate(exchange, String.class);
                    if (text == null) continue;
                    buffer.append(text);
                }
                return buffer.toString();
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                for (Expression expression : expressions) {
                    expression.init(context);
                }
            }

            public String toString() {
                if (description != null) {
                    return description;
                }
                return "concat(" + String.valueOf(expressions) + ")";
            }
        };
    }

    private static Expression concatExpressionOptimized(final Collection<Expression> expressions, final String description) {
        return new ExpressionAdapter(){
            private Collection<Object> optimized;
            private String optimizedValue;

            @Override
            public Object evaluate(Exchange exchange) {
                if (this.optimizedValue != null) {
                    return this.optimizedValue;
                }
                StringBuilder buffer = new StringBuilder(256);
                Collection col = this.optimized != null ? this.optimized : expressions;
                for (Object obj : col) {
                    if (obj instanceof Expression) {
                        Expression expression = (Expression)obj;
                        String text = expression.evaluate(exchange, String.class);
                        if (text == null) continue;
                        buffer.append(text);
                        continue;
                    }
                    if (obj == null) continue;
                    buffer.append(obj);
                }
                return buffer.toString();
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                if (this.optimized == null) {
                    ArrayList<Object> preprocessedExpression = new ArrayList<Object>(expressions.size());
                    boolean constantsOnly = true;
                    for (Expression expression : expressions) {
                        expression.init(context);
                        if (expression instanceof ConstantExpressionAdapter) {
                            ConstantExpressionAdapter constantExpressionAdapter = (ConstantExpressionAdapter)expression;
                            Object value = constantExpressionAdapter.getValue();
                            preprocessedExpression.add(value.toString());
                            continue;
                        }
                        preprocessedExpression.add(expression);
                        constantsOnly = false;
                    }
                    if (constantsOnly) {
                        StringBuilder sb = new StringBuilder(256);
                        for (Object e : preprocessedExpression) {
                            sb.append(e);
                        }
                        this.optimizedValue = sb.toString();
                    } else {
                        this.optimized = preprocessedExpression;
                    }
                } else {
                    for (Expression expression : expressions) {
                        expression.init(context);
                    }
                }
            }

            public String toString() {
                if (description != null) {
                    return description;
                }
                return "concat(" + String.valueOf(expressions) + ")";
            }
        };
    }

    public static Expression messageIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageId();
            }

            public String toString() {
                return "messageId";
            }
        };
    }

    public static Expression messageTimestampExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageTimestamp();
            }

            public String toString() {
                return "messageTimestamp";
            }
        };
    }

    public static Expression exchangeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getExchangeId();
            }

            public String toString() {
                return "exchangeId";
            }
        };
    }

    public static Expression routeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return ExchangeHelper.getRouteId(exchange);
            }

            public String toString() {
                return "routeId";
            }
        };
    }

    public static Expression fromRouteIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getFromRouteId();
            }

            public String toString() {
                return "fromRouteId";
            }
        };
    }

    public static Expression routeGroupExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return ExchangeHelper.getRouteGroup(exchange);
            }

            public String toString() {
                return "routeGroup";
            }
        };
    }

    public static Expression simpleExpression(final String expression) {
        if (LanguageSupport.hasSimpleFunction(expression)) {
            return new ExpressionAdapter(){
                private Expression exp;

                @Override
                public Object evaluate(Exchange exchange) {
                    return this.exp.evaluate(exchange, Object.class);
                }

                @Override
                public void init(CamelContext context) {
                    super.init(context);
                    Language language = context.resolveLanguage("simple");
                    this.exp = language.createExpression(expression);
                    this.exp.init(context);
                }

                public String toString() {
                    return "simple(" + expression + ")";
                }
            };
        }
        return ExpressionBuilder.constantExpression(expression);
    }

    public static Expression beanExpression(final String expression) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                Language language = context.resolveLanguage("bean");
                this.exp = language.createExpression(expression);
                this.exp.init(context);
            }

            public String toString() {
                return "bean(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(final Object bean, final String method) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                Language language = context.resolveLanguage("bean");
                this.exp = language.createExpression(null, new Object[]{null, bean, method});
                this.exp.init(context);
            }

            public String toString() {
                return "bean(" + String.valueOf(bean) + ", " + method + ")";
            }
        };
    }

    public static Expression beanExpression(final Expression expression, final String method) {
        return new ExpressionAdapter(){
            private Language language;

            @Override
            public Object evaluate(Exchange exchange) {
                Object bean = expression.evaluate(exchange, Object.class);
                Expression exp = this.language.createExpression(null, new Object[]{null, bean, method});
                exp.init(exchange.getContext());
                return exp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.language = context.resolveLanguage("bean");
            }

            public String toString() {
                return "bean(" + String.valueOf(expression) + ", " + method + ")";
            }
        };
    }

    public static Expression propertiesComponentExpression(final String key, final String defaultValue) {
        return new ExpressionAdapter(){
            private Expression exp;
            private PropertiesComponent pc;

            @Override
            public Object evaluate(Exchange exchange) {
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    return this.pc.parseUri("{{" + text + "}}");
                }
                catch (Exception e) {
                    if (defaultValue != null) {
                        return defaultValue;
                    }
                    throw RuntimeCamelException.wrapRuntimeCamelException(e);
                }
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.exp = ExpressionBuilder.simpleExpression(key);
                this.exp.init(context);
                this.pc = context.getPropertiesComponent();
            }

            public String toString() {
                return "properties(" + key + ")";
            }
        };
    }

    public static Expression propertiesComponentExist(final String key, final boolean negate) {
        return new ExpressionAdapter(){
            private PropertiesComponent pc;

            @Override
            public Object evaluate(Exchange exchange) {
                Optional<String> result = this.pc.resolveProperty(key);
                boolean answer = result.isPresent();
                if (negate) {
                    answer = !answer;
                }
                return answer;
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                this.pc = context.getPropertiesComponent();
            }

            public String toString() {
                return "propertiesExist(" + key + ")";
            }
        };
    }

    public static Expression tokenizePairExpression(String startToken, String endToken, boolean includeTokens) {
        return new TokenPairExpressionIterator(startToken, endToken, includeTokens);
    }

    public static Expression tokenizePairExpression(Expression source, String startToken, String endToken, boolean includeTokens) {
        return new TokenPairExpressionIterator(startToken, endToken, includeTokens);
    }

    public static Expression tokenizeXMLExpression(String tagName, String inheritNamespaceTagName) {
        return new TokenXMLExpressionIterator(tagName, inheritNamespaceTagName);
    }

    public static Expression tokenizeXMLExpression(Expression source, String tagName, String inheritNamespaceTagName) {
        return new TokenXMLExpressionIterator(source, tagName, inheritNamespaceTagName);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(path, mode, 1, null);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode, int group) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(path, mode, group, null);
    }

    public static Expression tokenizeXMLAwareExpression(final String path, final char mode, final int group, final Namespaces namespaces) {
        StringHelper.notEmpty(path, "path");
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                super.init(context);
                Language language = context.resolveLanguage("xtokenize");
                this.exp = language.createExpression(path, new Object[]{null, null, Character.valueOf(mode), group, namespaces});
                this.exp.init(context);
            }

            public String toString() {
                return "xtokenize(" + path + ")";
            }
        };
    }

    public static Expression bodyOneLine() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String body = exchange.getIn().getBody(String.class);
                if (body == null) {
                    return null;
                }
                body = body.replace(System.lineSeparator(), "");
                return body;
            }

            public String toString() {
                return "bodyOneLine()";
            }
        };
    }

    public static Expression prettyExpression(final Expression expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String body = expression.evaluate(exchange, String.class);
                if (body == null) {
                    return null;
                }
                if (body.startsWith("{") && body.endsWith("}") || body.startsWith("[") && body.endsWith("]")) {
                    return Jsoner.prettyPrint(body);
                }
                if (body.startsWith("<") && body.endsWith(">")) {
                    return ExpressionBuilder.prettyXml(body);
                }
                return body;
            }

            public String toString() {
                return "pretty(" + String.valueOf(expression) + ")";
            }
        };
    }

    public static Expression prettyBodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String body = exchange.getIn().getBody(String.class);
                if (body == null) {
                    return null;
                }
                if (body.startsWith("{") && body.endsWith("}") || body.startsWith("[") && body.endsWith("]")) {
                    return Jsoner.prettyPrint(body);
                }
                if (body.startsWith("<") && body.endsWith(">")) {
                    return ExpressionBuilder.prettyXml(body);
                }
                return body;
            }

            public String toString() {
                return "prettyBody()";
            }
        };
    }

    private static String prettyXml(String rawXml) {
        try {
            boolean includeDeclaration = rawXml.startsWith("<?xml");
            return XmlPrettyPrinter.pettyPrint(rawXml, 2, includeDeclaration);
        }
        catch (Exception e) {
            return rawXml;
        }
    }
}

