/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="micrometer", description="Display runtime metrics")
public class MicrometerConsole
extends AbstractDevConsole {
    public static final String TAGS = "tags";

    public MicrometerConsole() {
        super("camel", "micrometer", "Micrometer", "Display runtime metrics");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        HistogramSupport t;
        String name;
        boolean tags = "true".equals(options.getOrDefault(TAGS, "true"));
        StringBuilder sb = new StringBuilder();
        MeterRegistry mr = this.lookupMeterRegistry();
        sb.append(String.format("MeterRegistry: %s\n\n", mr.getClass().getName()));
        int i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Counter)) continue;
            Counter c = (Counter)m;
            if (i == 0) {
                sb.append("Counters:\n");
            }
            ++i;
            name = c.getId().getName();
            String cnt = String.valueOf(c.count());
            if (cnt.endsWith(".0") || cnt.endsWith(",0")) {
                cnt = cnt.substring(0, cnt.length() - 2);
            }
            sb.append(String.format("    %s: %s\n", name, cnt));
            if (!tags) continue;
            this.addTags(sb, c.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Gauge)) continue;
            Gauge g = (Gauge)m;
            if (i == 0) {
                sb.append("\nGauges:\n");
            }
            ++i;
            name = g.getId().getName();
            double cnt = g.value();
            sb.append(String.format("    %s: %s\n", name, cnt));
            if (!tags) continue;
            this.addTags(sb, g.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Timer)) continue;
            t = (Timer)m;
            if (i == 0) {
                sb.append("\nTimer:\n");
            }
            ++i;
            name = t.getId().getName();
            long count = t.count();
            long mean = Math.round(t.mean(TimeUnit.MILLISECONDS));
            long max = Math.round(t.max(TimeUnit.MILLISECONDS));
            long total = Math.round(t.totalTime(TimeUnit.MILLISECONDS));
            sb.append(String.format("    %s: %d (total: %dms mean: %dms max: %dms)\n", name, count, total, mean, max));
            if (!tags) continue;
            this.addTags(sb, t.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof LongTaskTimer)) continue;
            t = (LongTaskTimer)m;
            if (i == 0) {
                sb.append("\nLongTaskTimer:\n");
            }
            ++i;
            name = t.getId().getName();
            int tasks = t.activeTasks();
            long mean = Math.round(t.mean(TimeUnit.MILLISECONDS));
            long max = Math.round(t.max(TimeUnit.MILLISECONDS));
            long duration = Math.round(t.duration(TimeUnit.MILLISECONDS));
            sb.append(String.format("    %s: %d (duration: %dms mean: %dms max: %dms)\n", name, tasks, duration, mean, max));
            if (!tags) continue;
            this.addTags(sb, t.getId());
        }
        i = 0;
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof DistributionSummary)) continue;
            DistributionSummary d = (DistributionSummary)m;
            if (i == 0) {
                sb.append("\nDistributionSummary:\n");
            }
            ++i;
            name = d.getId().getName();
            long count = d.count();
            double mean = d.mean();
            double max = d.max();
            double total = d.totalAmount();
            sb.append(String.format("    %s: %d (total: %f mean: %f max: %f)\n", name, count, total, mean, max));
            if (!tags) continue;
            this.addTags(sb, d.getId());
        }
        return sb.toString();
    }

    protected void addTags(StringBuilder sb, Meter.Id id) {
        StringJoiner sj = new StringJoiner(" ");
        for (Tag tag : id.getTags()) {
            sj.add(tag.getKey() + "=" + tag.getValue());
        }
        if (sj.length() > 0) {
            sb.append(String.format("        %s\n", sj));
        }
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        HistogramSupport t;
        JsonObject jo;
        boolean tags = "true".equals(options.getOrDefault(TAGS, "true"));
        JsonObject root = new JsonObject();
        MeterRegistry mr = this.lookupMeterRegistry();
        root.put("meterRegistryClass", mr.getClass().getName());
        int i = 0;
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (Meter m : mr.getMeters()) {
            String cnt;
            if (!(m instanceof Counter)) continue;
            Counter c = (Counter)m;
            if (i == 0) {
                root.put("counters", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put("name", c.getId().getName());
            if (c.getId().getDescription() != null) {
                jo.put("description", c.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            if ((cnt = String.valueOf(c.count())).endsWith(".0") || cnt.endsWith(",0")) {
                cnt = cnt.substring(0, cnt.length() - 2);
                jo.put("count", Long.valueOf(cnt));
            } else {
                jo.put("count", c.count());
            }
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Gauge)) continue;
            Gauge g = (Gauge)m;
            if (i == 0) {
                root.put("gauges", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put("name", g.getId().getName());
            if (g.getId().getDescription() != null) {
                jo.put("description", g.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put("value", g.value());
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof Timer)) continue;
            t = (Timer)m;
            if (i == 0) {
                root.put("timers", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put("name", t.getId().getName());
            if (t.getId().getDescription() != null) {
                jo.put("description", t.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put("count", t.count());
            jo.put("mean", Math.round(t.mean(TimeUnit.MILLISECONDS)));
            jo.put("max", Math.round(t.max(TimeUnit.MILLISECONDS)));
            jo.put("total", Math.round(t.totalTime(TimeUnit.MILLISECONDS)));
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof LongTaskTimer)) continue;
            t = (LongTaskTimer)m;
            if (i == 0) {
                root.put("longTaskTimers", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put("name", t.getId().getName());
            if (t.getId().getDescription() != null) {
                jo.put("description", t.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put("activeTasks", t.activeTasks());
            jo.put("mean", Math.round(t.mean(TimeUnit.MILLISECONDS)));
            jo.put("max", Math.round(t.max(TimeUnit.MILLISECONDS)));
            jo.put("duration", Math.round(t.duration(TimeUnit.MILLISECONDS)));
            list.add(jo);
        }
        list.sort(this::sortByName);
        i = 0;
        list = new ArrayList();
        for (Meter m : mr.getMeters()) {
            if (!(m instanceof DistributionSummary)) continue;
            DistributionSummary d = (DistributionSummary)m;
            if (i == 0) {
                root.put("distribution", list);
            }
            ++i;
            jo = new JsonObject();
            jo.put("name", d.getId().getName());
            if (d.getId().getDescription() != null) {
                jo.put("description", d.getId().getDescription());
            }
            if (tags) {
                this.addTags(m, jo);
            }
            jo.put("count", d.count());
            jo.put("mean", d.mean());
            jo.put("max", d.max());
            jo.put("totalAmount", d.totalAmount());
            list.add(jo);
        }
        return root;
    }

    private void addTags(Meter m, JsonObject root) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (Tag t : m.getId().getTags()) {
            JsonObject jo = new JsonObject();
            jo.put("key", t.getKey());
            jo.put("value", t.getValue());
            list.add(jo);
        }
        if (!list.isEmpty()) {
            root.put(TAGS, list);
        }
    }

    private MeterRegistry lookupMeterRegistry() {
        return MicrometerUtils.getOrCreateMeterRegistry(this.getCamelContext().getRegistry(), "metricsRegistry");
    }

    private int sortByName(JsonObject o1, JsonObject o2) {
        return o1.getString("name").compareToIgnoreCase(o2.getString("name"));
    }
}

