/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.messagehistory;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.util.function.Predicate;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.component.micrometer.MicrometerUtils;

public interface MicrometerMessageHistoryNamingStrategy {
    public static final Predicate<Meter.Id> MESSAGE_HISTORIES = id -> "CamelMessageHistory".equals(id.getTag("kind"));
    public static final MicrometerMessageHistoryNamingStrategy DEFAULT = (route, node) -> "camel.message.history";
    public static final MicrometerMessageHistoryNamingStrategy LEGACY = new MicrometerMessageHistoryNamingStrategy(){

        @Override
        public String getName(Route route, NamedNode node) {
            return MicrometerUtils.legacyName("camel.message.history");
        }
    };

    public String getName(Route var1, NamedNode var2);

    default public String formatName(String name) {
        return name;
    }

    default public Tags getTags(Route route, NamedNode node) {
        return Tags.of("camelContext", route.getCamelContext().getName(), "kind", "CamelMessageHistory", "routeId", route.getId(), "nodeId", node.getId());
    }
}

