/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.micrometer.AbstractMicrometerProducer;
import org.apache.camel.component.micrometer.MicrometerEndpoint;
import org.apache.camel.component.micrometer.MicrometerTimerAction;

public class TimerProducer
extends AbstractMicrometerProducer<Timer> {
    public TimerProducer(MicrometerEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected Function<MeterRegistry, Timer> registrar(String name, String description, Iterable<Tag> tags) {
        return meterRegistry -> ((Timer.Builder)Timer.builder(name).description(description).tags((Iterable)tags)).register((MeterRegistry)meterRegistry);
    }

    @Override
    protected void doProcess(Exchange exchange, MicrometerEndpoint endpoint, Timer timer) {
        String propertyName = this.getPropertyName(timer.getId().getName());
        Timer.Sample sample = this.getTimerSampleFromExchange(exchange, propertyName);
        sample.stop(timer);
        exchange.removeProperty(propertyName);
    }

    @Override
    protected void doProcess(Exchange exchange, String metricsName, String metricsDescription, Iterable<Tag> tags) {
        MicrometerTimerAction action;
        MeterRegistry registry = this.getEndpoint().getRegistry();
        Message in = exchange.getIn();
        MicrometerTimerAction finalAction = in.getHeader("CamelMetricsTimerAction", (Object)(action = this.simple(exchange, this.getEndpoint().getAction(), MicrometerTimerAction.class)), MicrometerTimerAction.class);
        if (finalAction == MicrometerTimerAction.start) {
            this.handleStart(exchange, registry, metricsName);
        } else if (finalAction == MicrometerTimerAction.stop) {
            this.handleStop(exchange, metricsName, metricsDescription, tags);
        }
    }

    private void handleStop(Exchange exchange, String metricsName, String metricsDescription, Iterable<Tag> tags) {
        if (this.getTimerSampleFromExchange(exchange, this.getPropertyName(metricsName)) != null) {
            this.doProcess(exchange, this.getEndpoint(), (Timer)this.getOrRegisterMeter(metricsName, metricsDescription, tags));
        }
    }

    void handleStart(Exchange exchange, MeterRegistry registry, String metricsName) {
        String propertyName = this.getPropertyName(metricsName);
        Timer.Sample sample = this.getTimerSampleFromExchange(exchange, propertyName);
        if (sample == null) {
            sample = Timer.start(registry);
            exchange.setProperty(propertyName, (Object)sample);
        }
    }

    String getPropertyName(String metricsName) {
        return "timer:" + metricsName;
    }

    Timer.Sample getTimerSampleFromExchange(Exchange exchange, String propertyName) {
        return exchange.getProperty(propertyName, Timer.Sample.class);
    }
}

