/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Gauge;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.component.micrometer.eventnotifier.AbstractMicrometerEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifierNamingStrategy;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.ManagementStrategy;

public class MicrometerRouteEventNotifier
extends AbstractMicrometerEventNotifier<CamelEvent.RouteEvent> {
    private final AtomicLong routesAdded = new AtomicLong();
    private final AtomicLong routesRunning = new AtomicLong();
    private final AtomicLong routesReloaded = new AtomicLong();
    private Gauge gaugeAdded;
    private Gauge gaugeRunning;
    private Gauge gaugeReloaded;
    private MicrometerRouteEventNotifierNamingStrategy namingStrategy = MicrometerRouteEventNotifierNamingStrategy.DEFAULT;
    boolean registerKamelets;
    boolean registerTemplates = true;

    public MicrometerRouteEventNotifier() {
        super(CamelEvent.RouteEvent.class);
    }

    public MicrometerRouteEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerRouteEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    protected void doInit() throws Exception {
        ManagementStrategy ms = this.getCamelContext().getManagementStrategy();
        if (ms != null && ms.getManagementAgent() != null) {
            this.registerKamelets = ms.getManagementAgent().getRegisterRoutesCreateByKamelet();
            this.registerTemplates = ms.getManagementAgent().getRegisterRoutesCreateByTemplate();
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.gaugeAdded = Gauge.builder(this.namingStrategy.getRouteAddedName(), this.routesAdded, value -> value.get()).baseUnit("routes").tags(this.namingStrategy.getTags(this.getCamelContext())).register(this.getMeterRegistry());
        this.gaugeRunning = Gauge.builder(this.namingStrategy.getRouteRunningName(), this.routesRunning, value -> value.get()).baseUnit("routes").tags(this.namingStrategy.getTags(this.getCamelContext())).register(this.getMeterRegistry());
        this.gaugeReloaded = Gauge.builder(this.namingStrategy.getRouteReloadedName(), this.routesReloaded, value -> value.get()).baseUnit("routes").tags(this.namingStrategy.getTags(this.getCamelContext())).register(this.getMeterRegistry());
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.gaugeAdded != null) {
            this.getMeterRegistry().remove(this.gaugeAdded);
        }
        if (this.gaugeRunning != null) {
            this.getMeterRegistry().remove(this.gaugeRunning);
        }
        if (this.gaugeReloaded != null) {
            this.getMeterRegistry().remove(this.gaugeReloaded);
        }
    }

    @Override
    public void notify(CamelEvent eventObject) {
        if (eventObject instanceof CamelEvent.RouteEvent) {
            boolean skip;
            CamelEvent.RouteEvent re = (CamelEvent.RouteEvent)eventObject;
            boolean bl = skip = re.getRoute().isCreatedByKamelet() && !this.registerKamelets || re.getRoute().isCreatedByRouteTemplate() && !this.registerTemplates;
            if (skip) {
                return;
            }
        }
        if (eventObject instanceof CamelEvent.RouteAddedEvent) {
            this.routesAdded.incrementAndGet();
        } else if (eventObject instanceof CamelEvent.RouteRemovedEvent) {
            this.routesAdded.decrementAndGet();
        } else if (eventObject instanceof CamelEvent.RouteStartedEvent) {
            this.routesRunning.incrementAndGet();
        } else if (eventObject instanceof CamelEvent.RouteStoppedEvent) {
            this.routesRunning.decrementAndGet();
        } else if (eventObject instanceof CamelEvent.RouteReloadedEvent) {
            this.routesReloaded.incrementAndGet();
        }
    }
}

