/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import org.apache.camel.Exchange;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.support.DefaultExchangeHolder;

public final class MinaPayloadHelper {
    private MinaPayloadHelper() {
    }

    public static Object getIn(MinaEndpoint endpoint, Exchange exchange) {
        if (endpoint.getConfiguration().isTransferExchange()) {
            return DefaultExchangeHolder.marshal(exchange);
        }
        return exchange.getIn().getBody();
    }

    public static Object getOut(MinaEndpoint endpoint, Exchange exchange) {
        if (endpoint.getConfiguration().isTransferExchange()) {
            return DefaultExchangeHolder.marshal(exchange);
        }
        return exchange.getOut().getBody();
    }

    public static void setIn(Exchange exchange, Object payload) {
        if (payload instanceof DefaultExchangeHolder) {
            DefaultExchangeHolder.unmarshal(exchange, (DefaultExchangeHolder)payload);
        } else {
            exchange.getIn().setBody(payload);
        }
    }

    public static void setOut(Exchange exchange, Object payload) {
        if (payload instanceof DefaultExchangeHolder) {
            DefaultExchangeHolder.unmarshal(exchange, (DefaultExchangeHolder)payload);
        } else {
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
            exchange.getOut().setBody(payload);
        }
    }
}

