/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.MinioClient;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import java.time.ZonedDateTime;
import okhttp3.OkHttpClient;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class MinioConfiguration
implements Cloneable {
    @UriPath(description="Bucket name")
    @Metadata(required=true)
    private String bucketName;
    @UriParam(label="common")
    private String endpoint;
    @UriParam(label="common")
    private Integer proxyPort;
    @UriParam(label="common")
    private boolean secure;
    @UriParam(label="common")
    private String region;
    @UriParam(label="advanced")
    private OkHttpClient customHttpClient;
    @UriParam(label="security", secret=true)
    private String accessKey;
    @UriParam(label="security", secret=true)
    private String secretKey;
    @UriParam(label="common", defaultValue="true")
    private boolean autoCreateBucket = true;
    @UriParam(label="common", defaultValue="false")
    private boolean objectLock;
    @UriParam(label="common")
    private String policy;
    @UriParam(label="security")
    private ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey;
    @UriParam(label="security")
    private ServerSideEncryption serverSideEncryption;
    @UriParam(label="common")
    @Metadata(autowired=true)
    private MinioClient minioClient;
    @UriParam(label="consumer", defaultValue="10")
    private int maxMessagesPerPoll = 10;
    @UriParam(label="consumer", defaultValue="60")
    private int maxConnections = 50 + this.maxMessagesPerPoll;
    @UriParam(label="consumer")
    private String objectName;
    @UriParam(label="consumer")
    private String delimiter;
    @UriParam(label="consumer")
    private boolean includeUserMetadata;
    @UriParam(label="consumer")
    private boolean includeVersions;
    @UriParam(label="consumer")
    private String prefix;
    @UriParam(label="consumer")
    private boolean recursive;
    @UriParam(label="consumer")
    private String startAfter;
    @UriParam(label="consumer")
    private boolean useVersion1;
    @UriParam(label="consumer")
    private boolean includeFolders;
    @UriParam(label="consumer")
    private long offset;
    @UriParam(label="consumer")
    private long length;
    @UriParam(label="consumer")
    private String versionId;
    @UriParam(label="consumer")
    private String matchETag;
    @UriParam(label="consumer")
    private String notMatchETag;
    @UriParam(label="consumer")
    private ZonedDateTime modifiedSince;
    @UriParam(label="consumer")
    private ZonedDateTime unModifiedSince;
    @UriParam(label="consumer")
    private String destinationBucketName;
    @UriParam(label="consumer")
    private String destinationObjectName;
    @UriParam(label="consumer", defaultValue="true")
    private boolean deleteAfterRead = true;
    @UriParam(label="consumer", defaultValue="false")
    private boolean moveAfterRead;
    @UriParam(label="consumer", defaultValue="false")
    private boolean bypassGovernanceMode;
    @UriParam(label="consumer", defaultValue="true")
    private boolean includeBody = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean autoCloseBody = true;
    @UriParam(label="producer")
    private String keyName;
    @UriParam(label="producer")
    private boolean deleteAfterWrite;
    @UriParam(label="producer")
    private String storageClass;
    @UriParam(label="producer", enums="copyObject,listObjects,deleteObject,deleteObjects,deleteBucket,listBuckets,getObject,getObjectRange,createDownloadLink,createUploadLink")
    private MinioOperations operation;
    @UriParam(label="producer")
    private boolean pojoRequest;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public OkHttpClient getCustomHttpClient() {
        return this.customHttpClient;
    }

    public void setCustomHttpClient(OkHttpClient customHttpClient) {
        this.customHttpClient = customHttpClient;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean isAutoCreateBucket() {
        return this.autoCreateBucket;
    }

    public void setAutoCreateBucket(boolean autoCreateBucket) {
        this.autoCreateBucket = autoCreateBucket;
    }

    public boolean isObjectLock() {
        return this.objectLock;
    }

    public void setObjectLock(boolean objectLock) {
        this.objectLock = objectLock;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public ServerSideEncryptionCustomerKey getServerSideEncryptionCustomerKey() {
        return this.serverSideEncryptionCustomerKey;
    }

    public void setServerSideEncryptionCustomerKey(ServerSideEncryptionCustomerKey serverSideEncryptionCustomerKey) {
        this.serverSideEncryptionCustomerKey = serverSideEncryptionCustomerKey;
    }

    public ServerSideEncryption getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public void setServerSideEncryption(ServerSideEncryption serverSideEncryption) {
        this.serverSideEncryption = serverSideEncryption;
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isIncludeUserMetadata() {
        return this.includeUserMetadata;
    }

    public void setIncludeUserMetadata(boolean includeUserMetadata) {
        this.includeUserMetadata = includeUserMetadata;
    }

    public boolean isIncludeVersions() {
        return this.includeVersions;
    }

    public void setIncludeVersions(boolean includeVersions) {
        this.includeVersions = includeVersions;
    }

    public boolean isIncludeFolders() {
        return this.includeFolders;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public void setStartAfter(String startAfter) {
        this.startAfter = startAfter;
    }

    public boolean isUseVersion1() {
        return this.useVersion1;
    }

    public void setUseVersion1(boolean useVersion1) {
        this.useVersion1 = useVersion1;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getMatchETag() {
        return this.matchETag;
    }

    public void setMatchETag(String matchETag) {
        this.matchETag = matchETag;
    }

    public String getNotMatchETag() {
        return this.notMatchETag;
    }

    public void setNotMatchETag(String notMatchETag) {
        this.notMatchETag = notMatchETag;
    }

    public ZonedDateTime getModifiedSince() {
        return this.modifiedSince;
    }

    public void setModifiedSince(ZonedDateTime modifiedSince) {
        this.modifiedSince = modifiedSince;
    }

    public ZonedDateTime getUnModifiedSince() {
        return this.unModifiedSince;
    }

    public void setUnModifiedSince(ZonedDateTime unModifiedSince) {
        this.unModifiedSince = unModifiedSince;
    }

    public String getDestinationBucketName() {
        return this.destinationBucketName;
    }

    public void setDestinationBucketName(String destinationBucketName) {
        this.destinationBucketName = destinationBucketName;
    }

    public String getDestinationObjectName() {
        return this.destinationObjectName;
    }

    public void setDestinationObjectName(String destinationObjectName) {
        this.destinationObjectName = destinationObjectName;
    }

    public boolean isDeleteAfterRead() {
        return this.deleteAfterRead;
    }

    public void setDeleteAfterRead(boolean deleteAfterRead) {
        this.deleteAfterRead = deleteAfterRead;
    }

    public boolean isMoveAfterRead() {
        return this.moveAfterRead;
    }

    public void setMoveAfterRead(boolean moveAfterRead) {
        this.moveAfterRead = moveAfterRead;
    }

    public boolean isBypassGovernanceMode() {
        return this.bypassGovernanceMode;
    }

    public void setBypassGovernanceMode(boolean bypassGovernanceMode) {
        this.bypassGovernanceMode = bypassGovernanceMode;
    }

    public boolean isIncludeBody() {
        return this.includeBody;
    }

    public void setIncludeBody(boolean includeBody) {
        this.includeBody = includeBody;
    }

    public boolean isAutoCloseBody() {
        return this.autoCloseBody;
    }

    public void setAutoCloseBody(boolean autoCloseBody) {
        this.autoCloseBody = autoCloseBody;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public boolean isDeleteAfterWrite() {
        return this.deleteAfterWrite;
    }

    public void setDeleteAfterWrite(boolean deleteAfterWrite) {
        this.deleteAfterWrite = deleteAfterWrite;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public MinioOperations getOperation() {
        return this.operation;
    }

    public void setOperation(MinioOperations operation) {
        this.operation = operation;
    }

    public boolean isPojoRequest() {
        return this.pojoRequest;
    }

    public void setPojoRequest(boolean pojoRequest) {
        this.pojoRequest = pojoRequest;
    }

    public MinioConfiguration copy() {
        try {
            return (MinioConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }
}

