/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.support.ExchangeHelper;

public final class OutputStreamBuilder
extends OutputStream {
    private final OutputStream outputStream;

    private OutputStreamBuilder(Exchange exchange) {
        this.outputStream = ExchangeHelper.isStreamCachingEnabled(exchange) ? new CachedOutputStream(exchange) : new ByteArrayOutputStream();
    }

    public static OutputStreamBuilder withExchange(Exchange exchange) {
        return new OutputStreamBuilder(exchange);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public Object build() throws IOException {
        OutputStream outputStream2 = this.outputStream;
        if (outputStream2 instanceof CachedOutputStream) {
            CachedOutputStream cachedOutputStream = (CachedOutputStream)outputStream2;
            return cachedOutputStream.newStreamCache();
        }
        return ((ByteArrayOutputStream)this.outputStream).toByteArray();
    }
}

