/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.component.mllp.internal.Hl7Util;

public class MllpException
extends Exception {
    final byte[] hl7MessageBytes;
    final byte[] hl7AcknowledgementBytes;
    final Hl7Util hl7Util;
    final boolean logPhi;

    public MllpException(String message, boolean logPhi) {
        this(message, null, null, null, logPhi);
    }

    public MllpException(String message, Throwable cause, boolean logPhi) {
        this(message, null, null, cause, logPhi);
    }

    public MllpException(String message, byte[] hl7MessageBytes, boolean logPhi) {
        this(message, hl7MessageBytes, null, null, logPhi);
    }

    public MllpException(String message, byte[] hl7MessageBytes, Throwable cause, boolean logPhi) {
        this(message, hl7MessageBytes, null, cause, logPhi);
    }

    public MllpException(String message, byte[] hl7MessageBytes, byte[] hl7AcknowledgementBytes, boolean logPhi) {
        this(message, hl7MessageBytes, hl7AcknowledgementBytes, null, logPhi);
    }

    public MllpException(String message, byte[] hl7MessageBytes, byte[] hl7AcknowledgementBytes, Throwable cause, boolean logPhi) {
        super(message, cause);
        this.logPhi = logPhi;
        this.hl7Util = new Hl7Util(5120, logPhi);
        this.hl7MessageBytes = (byte[])(hl7MessageBytes != null && hl7MessageBytes.length > 0 ? hl7MessageBytes : null);
        this.hl7AcknowledgementBytes = (byte[])(hl7AcknowledgementBytes != null && hl7AcknowledgementBytes.length > 0 ? hl7AcknowledgementBytes : null);
    }

    public boolean hasHl7MessageBytes() {
        return this.hl7MessageBytes != null && this.hl7MessageBytes.length > 0;
    }

    public byte[] getHl7MessageBytes() {
        return this.hl7MessageBytes;
    }

    public boolean hasHl7AcknowledgementBytes() {
        return this.hl7AcknowledgementBytes != null && this.hl7AcknowledgementBytes.length > 0;
    }

    public byte[] getHl7AcknowledgementBytes() {
        return this.hl7AcknowledgementBytes;
    }

    @Override
    public String getMessage() {
        String answer;
        if (!this.logPhi) {
            return super.getMessage();
        }
        if (this.hasHl7MessageBytes() || this.hasHl7AcknowledgementBytes()) {
            String parentMessage = super.getMessage();
            StringBuilder messageBuilder = new StringBuilder(parentMessage.length() + (this.hasHl7MessageBytes() ? this.hl7MessageBytes.length : 0) + (this.hasHl7AcknowledgementBytes() ? this.hl7AcknowledgementBytes.length : 0));
            messageBuilder.append(parentMessage);
            if (this.hasHl7MessageBytes()) {
                messageBuilder.append("\n\t{hl7Message [").append(this.hl7MessageBytes.length).append("] = ");
                this.hl7Util.appendBytesAsPrintFriendlyString(messageBuilder, this.hl7MessageBytes, 0, this.hl7MessageBytes.length);
                messageBuilder.append('}');
            }
            if (this.hasHl7AcknowledgementBytes()) {
                messageBuilder.append("\n\t{hl7Acknowledgement [").append(this.hl7AcknowledgementBytes.length).append("] = ");
                this.hl7Util.appendBytesAsPrintFriendlyString(messageBuilder, this.hl7AcknowledgementBytes, 0, this.hl7AcknowledgementBytes.length);
                messageBuilder.append('}');
            }
            answer = messageBuilder.toString();
        } else {
            answer = super.getMessage();
        }
        return answer;
    }
}

