/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Handler;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.component.mock.AssertionClauseTask;
import org.apache.camel.component.mock.AssertionTask;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NotifyBuilderMatcher;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionComparator;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.0.0", scheme="mock", title="Mock", syntax="mock:name", producerOnly=true, remote=false, category={Category.CORE, Category.TESTING}, lenientProperties=true)
public class MockEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint,
NotifyBuilderMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(MockEndpoint.class);
    protected volatile Processor reporter;
    private volatile Processor defaultProcessor;
    private volatile Map<Integer, Processor> processors;
    private volatile List<Exchange> receivedExchanges;
    private volatile List<Throwable> failures;
    private volatile List<Runnable> tests;
    private volatile CountDownLatch latch;
    private volatile AssertionError failFastAssertionError;
    private volatile int expectedMinimumCount;
    private volatile List<?> expectedBodyValues;
    private volatile List<Object> actualBodyValues;
    private volatile Map<String, Object> expectedHeaderValues;
    private volatile Map<String, Object> actualHeaderValues;
    private volatile Map<String, Object> expectedPropertyValues;
    private volatile Map<String, Object> expectedVariableValues;
    private final AtomicInteger counter = new AtomicInteger();
    @UriPath(description="Name of mock endpoint")
    @Metadata(required=true)
    private String name;
    @UriParam(label="producer", defaultValue="-1")
    private int expectedCount;
    @UriParam(label="producer", javaType="java.time.Duration")
    private long sleepForEmptyTest;
    @UriParam(label="producer", javaType="java.time.Duration")
    private long resultWaitTime;
    @UriParam(label="producer", javaType="java.time.Duration")
    private long resultMinimumWaitTime;
    @UriParam(label="producer", javaType="java.time.Duration")
    private long assertPeriod;
    @UriParam(label="producer", defaultValue="-1")
    private int retainFirst;
    @UriParam(label="producer", defaultValue="-1")
    private int retainLast;
    @UriParam(label="producer")
    private int reportGroup;
    @UriParam(label="producer")
    private boolean log;
    @UriParam(label="producer")
    private boolean failFast = true;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean copyOnExchange = true;

    public MockEndpoint() {
        this.reset();
    }

    public MockEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.reset();
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public static MockEndpoint resolve(CamelContext context, String uri) {
        return CamelContextHelper.getMandatoryEndpoint(context, uri, MockEndpoint.class);
    }

    public static void assertWait(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        StopWatch watch = new StopWatch();
        long left = unit.toMillis(timeout);
        for (MockEndpoint endpoint : endpoints) {
            if (!endpoint.await(left, TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)("Timeout waiting for endpoints to receive enough messages. " + endpoint.getEndpointUri() + " timed out."));
            }
            if ((left -= watch.taken()) > 0L) continue;
            left = 0L;
        }
    }

    public static void assertIsSatisfied(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        MockEndpoint.assertWait(timeout, unit, endpoints);
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(CamelContext context) throws InterruptedException {
        ObjectHelper.notNull(context, "camelContext");
        Collection<Endpoint> endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getOriginalEndpoint();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(CamelContext context, long timeout, TimeUnit unit) throws InterruptedException {
        ObjectHelper.notNull(context, "camelContext");
        ObjectHelper.notNull(unit, "unit");
        Collection<Endpoint> endpoints = context.getEndpoints();
        long millis = unit.toMillis(timeout);
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getOriginalEndpoint();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.setResultWaitTime(millis);
            mockEndpoint.assertIsSatisfied();
        }
    }

    public static void setAssertPeriod(CamelContext context, long period) {
        ObjectHelper.notNull(context, "camelContext");
        Collection<Endpoint> endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getOriginalEndpoint();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.setAssertPeriod(period);
        }
    }

    public static void resetMocks(CamelContext context) {
        ObjectHelper.notNull(context, "camelContext");
        Collection<Endpoint> endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getOriginalEndpoint();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.reset();
        }
    }

    public static void expectsMessageCount(int count, MockEndpoint ... endpoints) {
        for (MockEndpoint endpoint : endpoints) {
            endpoint.setExpectedMessageCount(count);
        }
    }

    @Override
    public List<Exchange> getExchanges() {
        return this.getReceivedExchanges();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from this endpoint");
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultAsyncProducer(this){

            @Override
            public boolean process(Exchange exchange, AsyncCallback callback) {
                MockEndpoint.this.onExchange(exchange);
                callback.done(true);
                return true;
            }
        };
    }

    public void reset() {
        this.safeLatchReset();
        this.expectedCount = -1;
        this.counter.set(0);
        this.defaultProcessor = null;
        this.processors = new HashMap<Integer, Processor>();
        this.receivedExchanges = new CopyOnWriteArrayList<Exchange>();
        this.failures = new CopyOnWriteArrayList<Throwable>();
        this.tests = new CopyOnWriteArrayList<Runnable>();
        this.failFastAssertionError = null;
        this.sleepForEmptyTest = 0L;
        this.resultWaitTime = 0L;
        this.resultMinimumWaitTime = 0L;
        this.assertPeriod = 0L;
        this.expectedMinimumCount = -1;
        this.expectedBodyValues = null;
        this.actualBodyValues = new ArrayList<Object>();
        this.expectedHeaderValues = null;
        this.actualHeaderValues = null;
        this.expectedPropertyValues = null;
        this.expectedVariableValues = null;
        this.retainFirst = -1;
        this.retainLast = -1;
    }

    @Handler
    public void handle(Exchange exchange) throws Exception {
        this.onExchange(exchange);
    }

    public void whenExchangeReceived(int index, Processor processor) {
        this.processors.put(index, processor);
    }

    public void whenAnyExchangeReceived(Processor processor) {
        this.defaultProcessor = processor;
    }

    public void returnReplyBody(final Expression expression) {
        this.defaultProcessor = new Processor(){
            private boolean initDone;

            @Override
            public void process(Exchange exchange) {
                if (!this.initDone) {
                    expression.init(exchange.getContext());
                    this.initDone = true;
                }
                Object exp = expression.evaluate(exchange, Object.class);
                exchange.getMessage().setBody(exp);
            }
        };
    }

    public void returnReplyHeader(final String headerName, final Expression expression) {
        this.defaultProcessor = new Processor(){
            private boolean initDone;

            @Override
            public void process(Exchange exchange) {
                if (!this.initDone) {
                    expression.init(exchange.getContext());
                    this.initDone = true;
                }
                Object exp = expression.evaluate(exchange, Object.class);
                exchange.getMessage().setHeader(headerName, exp);
            }
        };
    }

    public void assertIsSatisfied() throws InterruptedException {
        this.assertIsSatisfied(this.sleepForEmptyTest);
    }

    public void assertIsSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        LOG.info("Asserting: {} is satisfied", (Object)this);
        this.doAssertIsSatisfied(timeoutForEmptyEndpoints);
        if (this.assertPeriod > 0L) {
            Thread.sleep(this.assertPeriod);
            LOG.info("Re-asserting: {} is satisfied after {} millis", (Object)this, (Object)this.assertPeriod);
            this.doAssertIsSatisfied(0L);
        }
    }

    protected void doAssertIsSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        if (this.expectedCount == 0) {
            if (timeoutForEmptyEndpoints > 0L) {
                LOG.debug("Sleeping for: {} millis to check there really are no messages received", (Object)timeoutForEmptyEndpoints);
                Thread.sleep(timeoutForEmptyEndpoints);
            }
            this.assertEquals("Received message count", this.expectedCount, this.getReceivedCounter());
        } else if (this.expectedCount > 0) {
            if (this.expectedCount != this.getReceivedCounter()) {
                this.waitForCompleteLatch();
            }
            if (this.failFastAssertionError == null) {
                this.assertEquals("Received message count", this.expectedCount, this.getReceivedCounter());
            }
        } else if (this.expectedMinimumCount > 0 && this.getReceivedCounter() < this.expectedMinimumCount) {
            this.waitForCompleteLatch();
        }
        if (this.failFastAssertionError != null) {
            throw this.failFastAssertionError;
        }
        if (this.expectedMinimumCount >= 0) {
            int receivedCounter = this.getReceivedCounter();
            this.assertTrue("Received message count " + receivedCounter + ", expected at least " + this.expectedMinimumCount, this.expectedMinimumCount <= receivedCounter);
        }
        this.runTests();
        this.evalFailures();
    }

    private void evalFailures() {
        for (Throwable failure : this.failures) {
            if (failure == null) continue;
            LOG.error("Caught exception on {} due to: {}", new Object[]{this.getEndpointUri(), failure.getMessage(), failure});
            this.fail(failure);
        }
    }

    private void runTests() {
        for (Runnable test : this.tests) {
            boolean skip = this.failFast && test instanceof AssertionTask;
            if (skip) continue;
            test.run();
        }
    }

    public void assertIsNotSatisfied() throws InterruptedException {
        boolean failed = false;
        try {
            this.assertIsSatisfied();
            failed = true;
        }
        catch (AssertionError e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caught expected failure: {}", (Object)((Throwable)((Object)e)).getMessage(), (Object)e);
            }
            LOG.info("Caught expected failure: {}", (Object)((Throwable)((Object)e)).getMessage());
        }
        if (failed) {
            this.fail("Expected assertion failure but test succeeded!");
        }
    }

    public void assertIsNotSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        boolean failed = false;
        try {
            this.assertIsSatisfied(timeoutForEmptyEndpoints);
            failed = true;
        }
        catch (AssertionError e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caught expected failure: {}", (Object)((Throwable)((Object)e)).getMessage(), (Object)e);
            }
            LOG.info("Caught expected failure: {}", (Object)((Throwable)((Object)e)).getMessage());
        }
        if (failed) {
            this.fail("Expected assertion failure but test succeeded!");
        }
    }

    public void expectedMessageCount(int expectedCount) {
        this.setExpectedMessageCount(expectedCount);
    }

    public long getAssertPeriod() {
        return this.assertPeriod;
    }

    public void setAssertPeriod(long period) {
        this.assertPeriod = period;
    }

    public void expectedMinimumMessageCount(int expectedCount) {
        this.setMinimumExpectedMessageCount(expectedCount);
    }

    public void expectedHeaderReceived(String name, Object value) {
        if (this.expectedMinimumCount == -1 && this.expectedCount <= 0) {
            this.expectedMinimumMessageCount(1);
        }
        if (this.expectedHeaderValues == null) {
            HeadersMapFactory factory = this.getCamelContext().getCamelContextExtension().getHeadersMapFactory();
            this.expectedHeaderValues = factory != null ? factory.newMap() : new HashMap<String, Object>();
            this.expects(new MockAssertionTask());
        }
        this.expectedHeaderValues.put(name, value);
    }

    public void expectedNoHeaderReceived() {
        if (this.expectedMinimumCount == -1 && this.expectedCount <= 0) {
            this.expectedMinimumMessageCount(1);
        }
        this.expects(new AssertionTask(){

            @Override
            public void assertOnIndex(int i) {
                Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                MockEndpoint.this.assertFalse("Exchange " + i + " has headers", exchange.getIn().hasHeaders());
            }

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    this.assertOnIndex(i);
                }
            }
        });
    }

    public void expectedHeaderValuesReceivedInAnyOrder(String name, List<?> values) {
        this.expectedMessageCount(values.size());
        this.expects(() -> {
            CopyOnWriteArraySet actualHeaderValues = new CopyOnWriteArraySet(values);
            for (int i = 0; i < this.getReceivedExchanges().size(); ++i) {
                Exchange exchange = this.getReceivedExchange(i);
                Object actualValue = exchange.getIn().getHeader(name);
                for (Object expectedValue : actualHeaderValues) {
                    actualValue = this.extractActualValue(exchange, actualValue, expectedValue);
                    actualHeaderValues.remove(actualValue);
                }
            }
            this.assertTrue("Expected " + values.size() + " headers with key[" + name + "], received " + (values.size() - actualHeaderValues.size()) + " headers. Expected header values: " + String.valueOf(actualHeaderValues), actualHeaderValues.isEmpty());
        });
    }

    public void expectedHeaderValuesReceivedInAnyOrder(String name, Object ... values) {
        ArrayList<Object> valueList = new ArrayList<Object>(Arrays.asList(values));
        this.expectedHeaderValuesReceivedInAnyOrder(name, valueList);
    }

    public void expectedVariableReceived(String name, Object value) {
        if (this.expectedVariableValues == null) {
            this.expectedVariableValues = new HashMap<String, Object>();
        }
        this.expectedVariableValues.put(name, value);
        this.expects(new AssertionTask(){

            @Override
            public void assertOnIndex(int i) {
                Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                for (Map.Entry<String, Object> entry : MockEndpoint.this.expectedVariableValues.entrySet()) {
                    String key = entry.getKey();
                    Object expectedValue = entry.getValue();
                    Object actualValue = null;
                    if (expectedValue != null) {
                        actualValue = exchange.getVariable(key);
                        boolean hasKey = actualValue != null;
                        MockEndpoint.this.assertTrue("No variable with name " + key + " found for message: " + i, hasKey);
                    }
                    actualValue = MockEndpoint.this.extractActualValue(exchange, actualValue, expectedValue);
                    MockEndpoint.this.assertEquals("Variable with name " + key + " for message: " + i, expectedValue, actualValue);
                }
            }

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    this.assertOnIndex(i);
                }
            }
        });
    }

    public void expectedVariableValuesReceivedInAnyOrder(String name, List<?> values) {
        this.expectedMessageCount(values.size());
        this.expects(() -> {
            CopyOnWriteArraySet actualVariableValues = new CopyOnWriteArraySet(values);
            for (int i = 0; i < this.getReceivedExchanges().size(); ++i) {
                Exchange exchange = this.getReceivedExchange(i);
                Object actualValue = exchange.getVariable(name);
                for (Object expectedValue : actualVariableValues) {
                    actualValue = this.extractActualValue(exchange, actualValue, expectedValue);
                    actualVariableValues.remove(actualValue);
                }
            }
            this.assertTrue("Expected " + values.size() + " variables with key[" + name + "], received " + (values.size() - actualVariableValues.size()) + " variables. Expected variable values: " + String.valueOf(actualVariableValues), actualVariableValues.isEmpty());
        });
    }

    public void expectedVariableValuesReceivedInAnyOrder(String name, Object ... values) {
        ArrayList<Object> valueList = new ArrayList<Object>(Arrays.asList(values));
        this.expectedVariableValuesReceivedInAnyOrder(name, valueList);
    }

    public void expectedPropertyReceived(String name, Object value) {
        if (this.expectedPropertyValues == null) {
            this.expectedPropertyValues = new HashMap<String, Object>();
        }
        this.expectedPropertyValues.put(name, value);
        this.expects(new AssertionTask(){

            @Override
            public void assertOnIndex(int i) {
                Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                for (Map.Entry<String, Object> entry : MockEndpoint.this.expectedPropertyValues.entrySet()) {
                    String key = entry.getKey();
                    Object expectedValue = entry.getValue();
                    Object actualValue = null;
                    if (expectedValue != null) {
                        actualValue = exchange.getProperty(key);
                        boolean hasKey = actualValue != null;
                        MockEndpoint.this.assertTrue("No property with name " + key + " found for message: " + i, hasKey);
                    }
                    actualValue = MockEndpoint.this.extractActualValue(exchange, actualValue, expectedValue);
                    MockEndpoint.this.assertEquals("Property with name " + key + " for message: " + i, expectedValue, actualValue);
                }
            }

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    this.assertOnIndex(i);
                }
            }
        });
    }

    public void expectedPropertyValuesReceivedInAnyOrder(String name, List<?> values) {
        this.expectedMessageCount(values.size());
        this.expects(() -> {
            CopyOnWriteArraySet actualPropertyValues = new CopyOnWriteArraySet(values);
            for (int i = 0; i < this.getReceivedExchanges().size(); ++i) {
                Exchange exchange = this.getReceivedExchange(i);
                Object actualValue = exchange.getProperty(name);
                for (Object expectedValue : actualPropertyValues) {
                    actualValue = this.extractActualValue(exchange, actualValue, expectedValue);
                    actualPropertyValues.remove(actualValue);
                }
            }
            this.assertTrue("Expected " + values.size() + " properties with key[" + name + "], received " + (values.size() - actualPropertyValues.size()) + " properties. Expected property values: " + String.valueOf(actualPropertyValues), actualPropertyValues.isEmpty());
        });
    }

    public void expectedPropertyValuesReceivedInAnyOrder(String name, Object ... values) {
        ArrayList<Object> valueList = new ArrayList<Object>(Arrays.asList(values));
        this.expectedPropertyValuesReceivedInAnyOrder(name, valueList);
    }

    public void expectedBodiesReceived(List<?> bodies) {
        this.expectedMessageCount(bodies.size());
        this.expectedBodyValues = bodies;
        this.actualBodyValues = new ArrayList<Object>();
        this.expects(new AssertionTask(){

            @Override
            public void assertOnIndex(int i) {
                Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                Object expectedBody = MockEndpoint.this.expectedBodyValues.get(i);
                Object actualBody = null;
                if (i < MockEndpoint.this.actualBodyValues.size()) {
                    actualBody = MockEndpoint.this.actualBodyValues.get(i);
                }
                actualBody = MockEndpoint.this.extractActualValue(exchange, actualBody, expectedBody);
                MockEndpoint.this.assertEquals("Body of message: " + i, expectedBody, actualBody);
            }

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.expectedBodyValues.size(); ++i) {
                    this.assertOnIndex(i);
                }
            }
        });
    }

    private Object extractActualValue(Exchange exchange, Object actualValue, Object expectedValue) {
        if (actualValue == null) {
            return null;
        }
        if (expectedValue != null) {
            String from = actualValue.getClass().getName();
            String to = expectedValue.getClass().getName();
            actualValue = this.getCamelContext().getTypeConverter().convertTo(expectedValue.getClass(), exchange, actualValue);
            this.assertTrue("There is no type conversion possible from " + from + " to " + to, actualValue != null);
        }
        return actualValue;
    }

    public void expectedMessagesMatches(Predicate ... predicates) {
        for (int i = 0; i < predicates.length; ++i) {
            final int messageIndex = i;
            final Predicate predicate = predicates[i];
            AssertionClauseTask clause = new AssertionClauseTask(this){

                @Override
                public void assertOnIndex(int index) {
                    if (messageIndex == index) {
                        this.addPredicate(predicate);
                        this.applyAssertionOn(MockEndpoint.this, index, MockEndpoint.this.assertExchangeReceived(index));
                    }
                }

                @Override
                public void run() {
                    for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                        this.assertOnIndex(i);
                    }
                }
            };
            this.expects(clause);
        }
    }

    public void expectedBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>(Arrays.asList(bodies));
        this.expectedBodiesReceived(bodyList);
    }

    public AssertionClause expectedBodyReceived() {
        this.expectedMessageCount(1);
        AssertionClauseTask clause = new AssertionClauseTask(this){

            @Override
            public void assertOnIndex(int index) {
                if (index == 0) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchange(index);
                    Object actualBody = exchange.getIn().getBody();
                    Expression exp = this.createExpression(MockEndpoint.this.getCamelContext());
                    Object expectedBody = exp.evaluate(exchange, Object.class);
                    MockEndpoint.this.assertEquals("Body of message: " + index, expectedBody, actualBody);
                }
            }

            @Override
            public void run() {
                this.assertOnIndex(0);
            }
        };
        this.expects(clause);
        return clause;
    }

    public void expectedBodiesReceivedInAnyOrder(List<?> bodies) {
        this.expectedMessageCount(bodies.size());
        this.expectedBodyValues = bodies;
        this.actualBodyValues = new ArrayList<Object>();
        this.expects(() -> {
            ArrayList<Object> actualBodyValuesSet = new ArrayList<Object>(this.actualBodyValues);
            for (int i = 0; i < this.expectedBodyValues.size(); ++i) {
                this.getReceivedExchange(i);
                Object expectedBody = this.expectedBodyValues.get(i);
                this.assertTrue("Message with body " + String.valueOf(expectedBody) + " was expected but not found in " + String.valueOf(actualBodyValuesSet), actualBodyValuesSet.remove(expectedBody));
            }
        });
    }

    public void expectedBodiesReceivedInAnyOrder(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>(Arrays.asList(bodies));
        this.expectedBodiesReceivedInAnyOrder(bodyList);
    }

    public void expectedFileExists(Path name) {
        this.expectedFileExists(name.toString(), null);
    }

    public void expectedFileExists(String name) {
        this.expectedFileExists(name, null);
    }

    public void expectedFileExists(Path name, String content) {
        this.expectedFileExists(name.toString(), content);
    }

    public void expectedFileExists(String name, String content) {
        File file = new File(FileUtil.normalizePath(name));
        this.expects(() -> {
            long timeout = 5000L;
            StopWatch watch = new StopWatch();
            boolean stop = false;
            while (!stop && !file.exists()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for the file to exist");
                    Thread.currentThread().interrupt();
                }
                stop = watch.taken() > 5000L;
            }
            this.assertTrue("The file should exists: " + name, file.exists());
            if (content != null) {
                String body = this.getCamelContext().getTypeConverter().convertTo(String.class, file);
                this.assertEquals("Content of file: " + name, content, body);
            }
        });
    }

    public void expectedExchangePattern(ExchangePattern exchangePattern) {
        this.expectedMessagesMatches(exchange -> exchange.getPattern().equals((Object)exchangePattern));
    }

    public void expectsAscending(final Expression expression) {
        this.expects(new AssertionTask(){
            private boolean initDone;

            @Override
            public void assertOnIndex(int index) {
                if (!this.initDone) {
                    expression.init(MockEndpoint.this.getCamelContext());
                    this.initDone = true;
                }
                MockEndpoint.this.assertMessagesSorted(expression, true, index);
            }

            @Override
            public void run() {
                if (!this.initDone) {
                    expression.init(MockEndpoint.this.getCamelContext());
                    this.initDone = true;
                }
                MockEndpoint.this.assertMessagesAscending(expression);
            }
        });
    }

    public AssertionClause expectsAscending() {
        AssertionClauseTask clause = new AssertionClauseTask(this){

            @Override
            public void assertOnIndex(int index) {
                MockEndpoint.this.assertMessagesSorted(this.createExpression(MockEndpoint.this.getCamelContext()), true, index);
            }

            @Override
            public void run() {
                MockEndpoint.this.assertMessagesAscending(this.createExpression(MockEndpoint.this.getCamelContext()));
            }
        };
        this.expects(clause);
        return clause;
    }

    public void expectsDescending(final Expression expression) {
        this.expects(new AssertionTask(){
            private boolean initDone;

            @Override
            public void assertOnIndex(int index) {
                if (!this.initDone) {
                    expression.init(MockEndpoint.this.getCamelContext());
                    this.initDone = true;
                }
                MockEndpoint.this.assertMessagesSorted(expression, false, index);
            }

            @Override
            public void run() {
                if (!this.initDone) {
                    expression.init(MockEndpoint.this.getCamelContext());
                    this.initDone = true;
                }
                MockEndpoint.this.assertMessagesDescending(expression);
            }
        });
    }

    public AssertionClause expectsDescending() {
        AssertionClauseTask clause = new AssertionClauseTask(this){

            @Override
            public void assertOnIndex(int index) {
                MockEndpoint.this.assertMessagesSorted(this.createExpression(MockEndpoint.this.getCamelContext()), false, index);
            }

            @Override
            public void run() {
                MockEndpoint.this.assertMessagesDescending(this.createExpression(MockEndpoint.this.getCamelContext()));
            }
        };
        this.expects(clause);
        return clause;
    }

    public void expectsNoDuplicates(final Expression expression) {
        this.expects(new AssertionTask(){
            private boolean initDone;
            private final Map<Object, Exchange> map = new HashMap<Object, Exchange>();

            @Override
            public void assertOnIndex(int index) {
                if (!this.initDone) {
                    expression.init(MockEndpoint.this.getCamelContext());
                    this.initDone = true;
                }
                MockEndpoint.this.duplicateCheck(index, expression, this.map);
            }

            @Override
            public void run() {
                if (!this.initDone) {
                    expression.init(MockEndpoint.this.getCamelContext());
                    this.initDone = true;
                }
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    this.assertOnIndex(i);
                }
            }
        });
    }

    private void duplicateCheck(int index, Expression expression, Map<Object, Exchange> map) {
        List<Exchange> list = this.getReceivedExchanges();
        Exchange e2 = list.get(index);
        this.evalDuplicate(expression, e2, map, index);
    }

    private void evalDuplicate(Expression expression, Exchange e2, Map<Object, Exchange> map, int i) {
        Object key = expression.evaluate(e2, Object.class);
        Exchange e1 = map.get(key);
        if (e1 != null) {
            this.fail("Duplicate message found on message " + i + " has value: " + String.valueOf(key) + " for expression: " + String.valueOf(expression) + ". Exchanges: " + String.valueOf(e1) + " and " + String.valueOf(e2));
        } else {
            map.put(key, e2);
        }
    }

    public AssertionClause expectsNoDuplicates() {
        AssertionClauseTask clause = new AssertionClauseTask(this){
            private final Map<Object, Exchange> map;
            private Expression exp;
            {
                this.map = new HashMap<Object, Exchange>();
            }

            @Override
            public void assertOnIndex(int index) {
                if (this.exp == null) {
                    this.exp = this.createExpression(MockEndpoint.this.getCamelContext());
                }
                MockEndpoint.this.duplicateCheck(index, this.exp, this.map);
            }

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    this.assertOnIndex(i);
                }
            }
        };
        this.expects(clause);
        return clause;
    }

    public void assertMessagesAscending(Expression expression) {
        expression.init(this.getCamelContext());
        this.assertMessagesSorted(expression, true);
    }

    public void assertMessagesDescending(Expression expression) {
        expression.init(this.getCamelContext());
        this.assertMessagesSorted(expression, false);
    }

    protected void assertMessagesSorted(Expression expression, boolean ascending) {
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 0; i < list.size(); ++i) {
            this.assertMessagesSorted(expression, ascending, i);
        }
    }

    protected void assertMessagesSorted(Expression expression, boolean ascending, int index) {
        String type = ascending ? "ascending" : "descending";
        ExpressionComparator comparator = new ExpressionComparator(expression);
        int prev = index - 1;
        if (prev > 0) {
            Exchange e2;
            List<Exchange> list = this.getReceivedExchanges();
            Exchange e1 = list.get(prev);
            int result = comparator.compare(e1, e2 = list.get(index));
            if (result == 0) {
                this.fail("Messages not " + type + ". Messages" + prev + " and " + index + " are equal with value: " + String.valueOf(expression.evaluate(e1, Object.class)) + " for expression: " + String.valueOf(expression) + ". Exchanges: " + String.valueOf(e1) + " and " + String.valueOf(e2));
            } else {
                if (!ascending) {
                    result *= -1;
                }
                if (result > 0) {
                    this.fail("Messages not " + type + ". Message " + prev + " has value: " + String.valueOf(expression.evaluate(e1, Object.class)) + " and message " + index + " has value: " + String.valueOf(expression.evaluate(e2, Object.class)) + " for expression: " + String.valueOf(expression) + ". Exchanges: " + String.valueOf(e1) + " and " + String.valueOf(e2));
                }
            }
        }
    }

    public void assertNoDuplicates(Expression expression) {
        expression.init(this.getCamelContext());
        HashMap<Object, Exchange> map = new HashMap<Object, Exchange>();
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 0; i < list.size(); ++i) {
            Exchange e2 = list.get(i);
            this.evalDuplicate(expression, e2, map, i);
        }
    }

    public void expects(Runnable runnable) {
        this.tests.add(runnable);
    }

    public AssertionClause message(final int messageIndex) {
        AssertionClauseTask clause = new AssertionClauseTask(this){

            @Override
            public void assertOnIndex(int index) {
                if (index == messageIndex) {
                    this.applyAssertionOn(MockEndpoint.this, index, MockEndpoint.this.assertExchangeReceived(index));
                }
            }

            @Override
            public void run() {
                this.assertOnIndex(messageIndex);
            }
        };
        this.expects(clause);
        return clause;
    }

    public AssertionClause allMessages() {
        AssertionClauseTask clause = new AssertionClauseTask(this){

            @Override
            public void assertOnIndex(int index) {
                if (index < MockEndpoint.this.getReceivedExchanges().size()) {
                    this.applyAssertionOn(MockEndpoint.this, index, MockEndpoint.this.assertExchangeReceived(index));
                }
            }

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    this.assertOnIndex(i);
                }
            }
        };
        this.expects(clause);
        return clause;
    }

    public Exchange assertExchangeReceived(int index) {
        int count = this.getReceivedCounter();
        this.assertTrue("Not enough messages received. Was: " + count, count > index);
        return this.getReceivedExchange(index);
    }

    @Override
    public void notifyBuilderOnExchange(Exchange exchange) {
        this.onExchange(exchange);
    }

    @Override
    public void notifyBuilderReset() {
        this.reset();
    }

    @Override
    public boolean notifyBuilderMatches() {
        if (this.failFastAssertionError != null) {
            return false;
        }
        for (Runnable test : this.tests) {
            boolean skip = this.failFast && test instanceof AssertionTask;
            if (skip) continue;
            try {
                test.run();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.latch != null) {
            try {
                return this.latch.await(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public int getReceivedCounter() {
        return this.counter.get();
    }

    public List<Exchange> getReceivedExchanges() {
        return this.receivedExchanges;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }

    public long getSleepForEmptyTest() {
        return this.sleepForEmptyTest;
    }

    public void setSleepForEmptyTest(long sleepForEmptyTest) {
        this.sleepForEmptyTest = sleepForEmptyTest;
    }

    public long getResultWaitTime() {
        return this.resultWaitTime;
    }

    public void setResultWaitTime(long resultWaitTime) {
        this.resultWaitTime = resultWaitTime;
    }

    public long getResultMinimumWaitTime() {
        return this.resultMinimumWaitTime;
    }

    public void setResultMinimumWaitTime(long resultMinimumWaitTime) {
        this.resultMinimumWaitTime = resultMinimumWaitTime;
    }

    public void setExpectedCount(int expectedCount) {
        this.setExpectedMessageCount(expectedCount);
    }

    public void setExpectedMessageCount(int expectedCount) {
        this.expectedCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(expectedCount);
    }

    public void setMinimumExpectedMessageCount(int expectedCount) {
        this.expectedMinimumCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(this.expectedMinimumCount);
    }

    public Processor getReporter() {
        return this.reporter;
    }

    public void setReporter(Processor reporter) {
        this.reporter = reporter;
    }

    public int getRetainFirst() {
        return this.retainFirst;
    }

    public void setRetainFirst(int retainFirst) {
        this.retainFirst = retainFirst;
    }

    public int getRetainLast() {
        return this.retainLast;
    }

    public void setRetainLast(int retainLast) {
        this.retainLast = retainLast;
    }

    public int getReportGroup() {
        return this.reportGroup;
    }

    public void setReportGroup(int reportGroup) {
        this.reportGroup = reportGroup;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isCopyOnExchange() {
        return this.copyOnExchange;
    }

    public void setCopyOnExchange(boolean copyOnExchange) {
        this.copyOnExchange = copyOnExchange;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Override
    public MockComponent getComponent() {
        return (MockComponent)super.getComponent();
    }

    protected synchronized void onExchange(Exchange exchange) {
        try {
            if (this.log) {
                String line = this.getComponent().getExchangeFormatter().format(exchange);
                LOG.info("mock:{} received #{} -> {}", new Object[]{this.getName(), this.counter.get() + 1, line});
            }
            if (this.reporter != null) {
                this.reporter.process(exchange);
            }
            Exchange copy = exchange;
            if (this.copyOnExchange) {
                copy = ExchangeHelper.createCopy(exchange, true);
            }
            this.performAssertions(exchange, copy);
            if (this.failFast) {
                this.doFailFast();
            }
        }
        catch (AssertionError | Exception e) {
            this.failures.add((Throwable)e);
        }
        finally {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    private void doFailFast() {
        int index = this.getReceivedCounter() - 1;
        for (Runnable test : this.tests) {
            if (!(test instanceof AssertionTask)) continue;
            AssertionTask task = (AssertionTask)test;
            try {
                LOG.debug("Running assertOnIndex({}) on task: {}", (Object)index, (Object)task);
                task.assertOnIndex(index);
            }
            catch (AssertionError e) {
                this.failFastAssertionError = e;
                LOG.debug("Assertion failed fast on {} received exchange due to {}", (Object)index, (Object)((Throwable)((Object)e)).getMessage());
                while (this.latch != null && this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
                break block2;
            }
        }
    }

    protected void performAssertions(Exchange exchange, Exchange copy) throws Exception {
        Processor processor;
        Message in = copy.getIn();
        if (this.expectedHeaderValues != null) {
            this.assertExpectedHeaderValues(in);
        }
        Object actualBody = in.getBody();
        if (this.expectedBodyValues != null) {
            actualBody = this.assertExpectedBodyValues(in, actualBody);
        }
        if (LOG.isDebugEnabled()) {
            String msg = MockEndpoint.buildLogMessage(this.getEndpointUri(), this.counter, copy, actualBody);
            LOG.debug(msg);
        }
        copy.setProperty("CamelReceivedTimestamp", (Object)new Date());
        this.addReceivedExchange(copy);
        int receivedCounter = this.counter.incrementAndGet();
        Processor processor2 = processor = this.processors.get(receivedCounter) != null ? this.processors.get(receivedCounter) : this.defaultProcessor;
        if (processor != null) {
            MockEndpoint.tryProcessing(exchange, processor);
        }
    }

    private static void tryProcessing(Exchange exchange, Processor processor) {
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    private static String buildLogMessage(String endpontUri, AtomicInteger counter, Exchange copy, Object actualBody) {
        String msg = endpontUri + " >>>> " + String.valueOf(counter) + " : " + String.valueOf(copy) + (String)(actualBody != null ? " with body: " + String.valueOf(actualBody) : "null body");
        if (copy.getIn().hasHeaders()) {
            msg = msg + " and headers:" + String.valueOf(copy.getIn().getHeaders());
        }
        return msg;
    }

    private Object assertExpectedBodyValues(Message in, Object actualBody) {
        int index = this.actualBodyValues.size();
        if (this.expectedBodyValues.size() > index) {
            Object body;
            Object expectedBody = this.expectedBodyValues.get(index);
            if (expectedBody != null && (body = in.getBody(expectedBody.getClass())) != null) {
                actualBody = body;
            }
            this.actualBodyValues.add(actualBody);
        }
        return actualBody;
    }

    private void assertExpectedHeaderValues(Message in) {
        if (this.actualHeaderValues == null) {
            HeadersMapFactory factory = this.getCamelContext().getCamelContextExtension().getHeadersMapFactory();
            this.actualHeaderValues = factory != null ? factory.newMap() : new HashMap<String, Object>();
        }
        if (in.hasHeaders()) {
            this.actualHeaderValues.putAll(in.getHeaders());
        }
    }

    protected void addReceivedExchange(Exchange copy) {
        if (this.isNotRetain()) {
            return;
        }
        if (this.retainAll()) {
            this.receivedExchanges.add(copy);
        } else {
            this.retainSome(copy);
        }
    }

    private void retainSome(Exchange copy) {
        if (this.retainFirst > 0 && this.counter.get() < this.retainFirst) {
            this.receivedExchanges.add(copy);
        } else if (this.retainLast > 0) {
            int index = this.receivedExchanges.size() - this.retainLast;
            if (index >= 0 && (this.retainFirst <= 0 || this.retainFirst <= index)) {
                this.receivedExchanges.remove(index);
            }
            this.receivedExchanges.add(copy);
        }
    }

    private boolean retainAll() {
        return this.retainFirst < 0 && this.retainLast < 0;
    }

    private boolean isNotRetain() {
        return this.retainFirst == 0 && this.retainLast == 0;
    }

    private void safeLatchReset() {
        if (this.latch == null) {
            return;
        }
        try {
            this.waitForCompleteLatch(this.resultWaitTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.latch = null;
    }

    protected void waitForCompleteLatch() throws InterruptedException {
        if (this.latch == null) {
            this.fail("Should have a latch!");
        }
        StopWatch watch = new StopWatch();
        this.waitForCompleteLatch(this.resultWaitTime);
        long delta = watch.taken();
        LOG.debug("Took {} millis to complete latch", (Object)delta);
        if (this.resultMinimumWaitTime > 0L && delta < this.resultMinimumWaitTime) {
            this.fail("Expected minimum " + this.resultMinimumWaitTime + " millis waiting on the result, but was faster with " + delta + " millis.");
        }
    }

    protected void waitForCompleteLatch(long timeout) throws InterruptedException {
        long waitTime = timeout == 0L ? 10000L : timeout;
        LOG.debug("Waiting on the latch for: {} millis", (Object)waitTime);
        if (!this.latch.await(waitTime, TimeUnit.MILLISECONDS)) {
            LOG.warn("The latch did not reach 0 within the specified time");
        }
    }

    protected void assertEquals(String message, int expectedValue, int actualValue) {
        if (expectedValue != actualValue) {
            this.logReceivedExchanges();
            this.fail(message + ". Expected: <" + expectedValue + "> but was: <" + actualValue + ">");
        }
    }

    protected void assertEquals(String message, Object expectedValue, Object actualValue) {
        if (!ObjectHelper.equal(expectedValue, actualValue)) {
            this.logReceivedExchanges();
            this.fail(message + ". Expected: <" + String.valueOf(expectedValue) + "> but was: <" + String.valueOf(actualValue) + ">");
        }
    }

    private void logReceivedExchanges() {
        for (Exchange exchange : this.receivedExchanges) {
            LOG.warn("Received exchange: {}", (Object)exchange);
            Message exchangeMessage = exchange.getMessage();
            if (exchangeMessage == null) continue;
            LOG.warn("Received exchange message: {}", (Object)exchangeMessage);
            Object body = exchangeMessage.getBody();
            if (body == null) continue;
            LOG.warn("Received exchange message body: {}", body);
            LOG.warn("Received exchange message body type: {}", body.getClass());
        }
    }

    protected void assertTrue(String message, boolean predicate) {
        if (!predicate) {
            this.fail(message);
        }
    }

    protected void assertFalse(String message, boolean predicate) {
        if (predicate) {
            this.fail(message);
        }
    }

    protected void fail(Object message) {
        if (LOG.isDebugEnabled()) {
            List<Exchange> list = this.getReceivedExchanges();
            int index = 0;
            for (Exchange exchange : list) {
                LOG.debug("{} failed and received[{}]: {}", new Object[]{this.getEndpointUri(), ++index, exchange});
            }
        }
        if (message instanceof Throwable) {
            Throwable cause = (Throwable)message;
            String msg = "Caught exception on " + this.getEndpointUri() + " due to: " + cause.getMessage();
            throw new AssertionError(msg, cause);
        }
        throw new AssertionError((Object)(this.getEndpointUri() + " " + String.valueOf(message)));
    }

    public int getExpectedMinimumCount() {
        return this.expectedMinimumCount;
    }

    public void await() throws InterruptedException {
        if (this.latch != null) {
            this.latch.await();
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.latch != null) {
            return this.latch.await(timeout, unit);
        }
        return true;
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    private Exchange getReceivedExchange(int index) {
        if (index <= this.receivedExchanges.size() - 1) {
            return this.receivedExchanges.get(index);
        }
        this.fail("There is no exchange at index " + index);
        return null;
    }

    private class MockAssertionTask
    implements AssertionTask {
        private MockAssertionTask() {
        }

        @Override
        public void assertOnIndex(int i) {
            Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
            for (Map.Entry<String, Object> entry : MockEndpoint.this.expectedHeaderValues.entrySet()) {
                String key = entry.getKey();
                Object expectedValue = entry.getValue();
                if (expectedValue != null) {
                    MockEndpoint.this.assertTrue("Exchange " + i + " has no headers", exchange.getIn().hasHeaders());
                    boolean hasKey = exchange.getIn().getHeaders().containsKey(key);
                    MockEndpoint.this.assertTrue("No header with name " + key + " found for message: " + i, hasKey);
                }
                Object actualValue = exchange.getIn().getHeader(key);
                actualValue = MockEndpoint.this.extractActualValue(exchange, actualValue, expectedValue);
                MockEndpoint.this.assertEquals("Header with name " + key + " for message: " + i, expectedValue, actualValue);
            }
        }

        @Override
        public void run() {
            for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                this.assertOnIndex(i);
            }
        }
    }
}

