/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.component.mock.MockExpressionClause;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.builder.PredicateBuilder;

public class MockValueBuilder
implements Expression,
Predicate {
    private final Expression expression;
    private boolean not;

    public MockValueBuilder(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void init(CamelContext context) {
        this.expression.init(context);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return this.expression.evaluate(exchange, type);
    }

    @Override
    public boolean matches(Exchange exchange) {
        return PredicateBuilder.toPredicate(this.getExpression()).matches(exchange);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }

    public Predicate matches(Expression expression) {
        return this.onNewPredicate(ExpressionToPredicateAdapter.toPredicate(expression));
    }

    public MockExpressionClause<Predicate> matches() {
        final AtomicReference<2> ref = new AtomicReference<2>();
        final MockExpressionClause<Predicate> answer = new MockExpressionClause<Predicate>(this.onNewPredicate(new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                Expression left = MockValueBuilder.this.expression;
                Expression right = (Expression)ref.get();
                return PredicateBuilder.isEqualTo(left, right).matches(exchange);
            }

            public String toString() {
                return String.valueOf(MockValueBuilder.this.expression) + " == " + String.valueOf(ref.get());
            }
        }));
        ExpressionAdapter right = new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return answer.evaluate(exchange, Object.class);
            }
        };
        ref.set(right);
        return answer;
    }

    public Predicate isNotEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isNotEqualTo(this.expression, right));
    }

    public Predicate isEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isEqualTo(this.expression, right));
    }

    public Predicate isEqualToIgnoreCase(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isEqualToIgnoreCase(this.expression, right));
    }

    public Predicate isLessThan(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThan(this.expression, right));
    }

    public Predicate isLessThanOrEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isLessThanOrEqualTo(this.expression, right));
    }

    public Predicate isGreaterThan(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThan(this.expression, right));
    }

    public Predicate isGreaterThanOrEqualTo(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.isGreaterThanOrEqualTo(this.expression, right));
    }

    public Predicate isInstanceOf(Class<?> type) {
        return this.onNewPredicate(PredicateBuilder.isInstanceOf(this.expression, type));
    }

    public Predicate isNull() {
        return this.onNewPredicate(PredicateBuilder.isNull(this.expression));
    }

    public Predicate isNotNull() {
        return this.onNewPredicate(PredicateBuilder.isNotNull(this.expression));
    }

    public Predicate not(Predicate predicate) {
        return this.onNewPredicate(PredicateBuilder.not(predicate));
    }

    public Predicate in(Object ... values) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Object value : values) {
            Expression right = this.asExpression(value);
            right = ExpressionBuilder.convertToExpression(right, this.expression);
            Predicate predicate = PredicateBuilder.isEqualTo(this.expression, right);
            predicates.add(predicate);
        }
        return this.in(predicates.toArray(new Predicate[0]));
    }

    public Predicate in(Predicate ... predicates) {
        return this.onNewPredicate(PredicateBuilder.in(predicates));
    }

    public Predicate startsWith(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.startsWith(this.expression, right));
    }

    public Predicate endsWith(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.endsWith(this.expression, right));
    }

    public Predicate contains(Object value) {
        Expression right = this.asExpression(value);
        return this.onNewPredicate(PredicateBuilder.contains(this.expression, right));
    }

    public Predicate regex(String regex) {
        return this.onNewPredicate(PredicateBuilder.regex(this.expression, regex));
    }

    public MockValueBuilder tokenize() {
        return this.tokenize("\n");
    }

    public MockValueBuilder tokenize(String token) {
        Expression newExp = ExpressionBuilder.tokenizeExpression(this.expression, token);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder tokenize(String token, int group, boolean skipFirst) {
        return this.tokenize(token, Integer.toString(group), skipFirst);
    }

    public MockValueBuilder tokenize(String token, String group, boolean skipFirst) {
        Expression newExp = ExpressionBuilder.tokenizeExpression(this.expression, token);
        if (group == null && skipFirst) {
            newExp = ExpressionBuilder.skipFirstExpression(newExp);
        }
        newExp = ExpressionBuilder.groupIteratorExpression(newExp, token, group, skipFirst);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder regexTokenize(String regex) {
        Expression newExp = ExpressionBuilder.regexTokenizeExpression(this.expression, regex);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder regexReplaceAll(String regex, String replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll(this.expression, regex, replacement);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder regexReplaceAll(String regex, Expression replacement) {
        Expression newExp = ExpressionBuilder.regexReplaceAll(this.expression, regex, replacement);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder convertTo(Class<?> type) {
        Expression newExp = ExpressionBuilder.convertToExpression(this.expression, type);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder convertToString() {
        return this.convertTo(String.class);
    }

    public MockValueBuilder append(Object value) {
        Expression newExp = ExpressionBuilder.append(this.expression, this.asExpression(value));
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder prepend(Object value) {
        Expression newExp = ExpressionBuilder.prepend(this.expression, this.asExpression(value));
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder sort(Comparator<?> comparator) {
        Expression newExp = ExpressionBuilder.sortExpression(this.expression, comparator);
        return this.onNewValueBuilder(newExp);
    }

    public MockValueBuilder not() {
        this.not = true;
        return this;
    }

    protected Predicate onNewPredicate(Predicate predicate) {
        if (this.not) {
            return PredicateBuilder.not(predicate);
        }
        return predicate;
    }

    protected Expression asExpression(Object value) {
        if (value instanceof Expression) {
            return (Expression)value;
        }
        return ExpressionBuilder.constantExpression(value);
    }

    protected MockValueBuilder onNewValueBuilder(Expression exp) {
        return new MockValueBuilder(exp);
    }
}

