/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.DefaultInterceptSendToEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToMockEndpointStrategy
implements EndpointStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToMockEndpointStrategy.class);
    private final String pattern;
    private final boolean skip;

    public InterceptSendToMockEndpointStrategy() {
        this(null);
    }

    public InterceptSendToMockEndpointStrategy(String pattern) {
        this(pattern, false);
    }

    public InterceptSendToMockEndpointStrategy(String pattern, boolean skip) {
        this.pattern = pattern;
        this.skip = skip;
    }

    @Override
    public Endpoint registerEndpoint(String uri, Endpoint endpoint) {
        if (endpoint instanceof InterceptSendToEndpoint) {
            return endpoint;
        }
        if (endpoint.getEndpointUri().startsWith("mock:")) {
            return endpoint;
        }
        if (this.matchPattern(uri, endpoint, this.pattern)) {
            Producer producer;
            DefaultInterceptSendToEndpoint proxy = new DefaultInterceptSendToEndpoint(endpoint, this.skip);
            Object key = "mock:" + endpoint.getEndpointKey().replaceFirst("://", ":");
            if (((String)key).contains("?")) {
                key = StringHelper.before((String)key, "?");
            }
            LOG.info("Adviced endpoint [{}] with mock endpoint [{}]", (Object)uri, key);
            Endpoint mock = endpoint.getCamelContext().getEndpoint((String)key, Endpoint.class);
            try {
                producer = mock.createProducer();
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
            producer = this.onInterceptEndpoint(uri, endpoint, mock, producer);
            proxy.setBefore(producer);
            return proxy;
        }
        return endpoint;
    }

    protected boolean matchPattern(String uri, Endpoint endpoint, String pattern) {
        return uri == null || pattern == null || EndpointHelper.matchEndpoint(endpoint.getCamelContext(), uri, pattern);
    }

    protected Producer onInterceptEndpoint(String uri, Endpoint endpoint, Endpoint mockEndpoint, Producer mockProducer) {
        return mockProducer;
    }

    public String toString() {
        return "InterceptSendToMockEndpointStrategy";
    }
}

