/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.support.builder.ExpressionBuilder;

public class MockExpressionClauseSupport<T> {
    private final T result;
    private Expression expressionValue;
    private ExpressionFactory expressionType;
    private volatile boolean initDone;

    public MockExpressionClauseSupport(T result) {
        this.result = result;
    }

    public T expression(Expression expression) {
        this.setExpressionValue(expression);
        if (expression instanceof ExpressionFactory) {
            ExpressionFactory expressionFactory = (ExpressionFactory)((Object)expression);
            this.setExpressionType(expressionFactory);
        }
        return this.result;
    }

    public T language(ExpressionFactory expression) {
        this.setExpressionType(expression);
        return this.result;
    }

    public T constant(Object value) {
        return this.expression(ExpressionBuilder.constantExpression(value));
    }

    public T exchange() {
        return this.expression(ExpressionBuilder.exchangeExpression());
    }

    public T inMessage() {
        return this.expression(ExpressionBuilder.inMessageExpression());
    }

    public T body() {
        return this.expression(ExpressionBuilder.bodyExpression());
    }

    public T body(Class<?> expectedType) {
        return this.expression(ExpressionBuilder.bodyExpression(expectedType));
    }

    public T header(String name) {
        return this.expression(ExpressionBuilder.headerExpression(name));
    }

    public T headers() {
        return this.expression(ExpressionBuilder.headersExpression());
    }

    public T exchangePattern() {
        return this.expression(ExpressionBuilder.exchangePatternExpression());
    }

    public T exchangeProperty(String name) {
        return this.expression(ExpressionBuilder.exchangePropertyExpression(name));
    }

    public T exchangeProperties() {
        return this.expression(ExpressionBuilder.exchangePropertiesExpression());
    }

    public T method(String bean) {
        return this.expression(ExpressionBuilder.beanExpression(bean));
    }

    public T method(String bean, String method) {
        if (method != null) {
            return this.expression(ExpressionBuilder.languageExpression("bean", bean + "?method=" + method));
        }
        return this.method(bean);
    }

    public T groovy(String text) {
        return this.expression(ExpressionBuilder.languageExpression("groovy", text));
    }

    public T jsonpath(String text) {
        return this.expression(ExpressionBuilder.languageExpression("jsonpath", text));
    }

    public T ognl(String text) {
        return this.expression(ExpressionBuilder.languageExpression("ognl", text));
    }

    public T mvel(String text) {
        return this.expression(ExpressionBuilder.languageExpression("mvel", text));
    }

    public T ref(String ref) {
        return this.expression(ExpressionBuilder.languageExpression("ref", ref));
    }

    public T spel(String text) {
        return this.expression(ExpressionBuilder.languageExpression("spel", text));
    }

    public T simple(String text) {
        return this.expression(ExpressionBuilder.languageExpression("simple", text));
    }

    public T hl7terser(String text) {
        return this.expression(ExpressionBuilder.languageExpression("hl7terser", text));
    }

    public T xpath(String text) {
        return this.expression(ExpressionBuilder.languageExpression("xpath", text));
    }

    public T xquery(String text) {
        return this.expression(ExpressionBuilder.languageExpression("xquery", text));
    }

    public T language(String language, String expression) {
        return this.expression(ExpressionBuilder.languageExpression(language, expression));
    }

    public T variable(String name) {
        return this.expression(ExpressionBuilder.variableExpression(name));
    }

    public T variables() {
        return this.expression(ExpressionBuilder.variablesExpression());
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    public void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    public ExpressionFactory getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionFactory expressionType) {
        this.expressionType = expressionType;
    }

    protected Expression createExpression(CamelContext camelContext) {
        Expression exp;
        if (this.getExpressionValue() == null) {
            if (this.getExpressionType() != null) {
                exp = this.getExpressionType().createExpression(camelContext);
                this.setExpressionValue(exp);
            } else {
                throw new IllegalStateException("No expression value configured");
            }
        }
        exp = this.getExpressionValue();
        if (!this.initDone) {
            exp.init(camelContext);
            this.initDone = true;
        }
        return exp;
    }

    protected void configureExpression(CamelContext camelContext, Expression expression) {
    }
}

