/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class ListDatabasesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String DATABASES = "databases";
    private final Decoder<T> decoder;
    private boolean retryReads;
    private long maxTimeMS;
    private BsonDocument filter;
    private Boolean nameOnly;
    private Boolean authorizedDatabasesOnly;
    private BsonValue comment;

    public ListDatabasesOperation(Decoder<T> decoder) {
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public ListDatabasesOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ListDatabasesOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public ListDatabasesOperation<T> nameOnly(Boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    public ListDatabasesOperation<T> authorizedDatabasesOnly(Boolean authorizedDatabasesOnly) {
        this.authorizedDatabasesOnly = authorizedDatabasesOnly;
        return this;
    }

    public ListDatabasesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean getNameOnly() {
        return this.nameOnly;
    }

    public Boolean getAuthorizedDatabasesOnly() {
        return this.authorizedDatabasesOnly;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListDatabasesOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, DATABASES), SyncOperationHelper.singleBatchCursorTransformer(DATABASES), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, DATABASES), AsyncOperationHelper.asyncSingleBatchCursorTransformer(DATABASES), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (serverDescription, connectionDescription) -> this.getCommand();
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("listDatabases", new BsonInt32(1));
        if (this.maxTimeMS > 0L) {
            command.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (this.filter != null) {
            command.put("filter", this.filter);
        }
        if (this.nameOnly != null) {
            command.put("nameOnly", new BsonBoolean(this.nameOnly));
        }
        if (this.authorizedDatabasesOnly != null) {
            command.put("authorizedDatabases", new BsonBoolean(this.authorizedDatabasesOnly));
        }
        DocumentHelper.putIfNotNull(command, "comment", this.comment);
        return command;
    }
}

