/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbTailTrackingManager;
import org.apache.camel.component.mongodb.MongoDbTailingThread;
import org.apache.camel.support.DefaultConsumer;

public class MongoDbTailableCursorConsumer
extends DefaultConsumer {
    private final MongoDbEndpoint endpoint;
    private ExecutorService executor;
    private MongoDbTailingThread tailingThread;

    public MongoDbTailableCursorConsumer(MongoDbEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.tailingThread != null) {
            this.tailingThread.stop();
        }
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool(this, this.endpoint.getEndpointUri(), 1);
        MongoDbTailTrackingManager trackingManager = this.initTailTracking();
        this.tailingThread = new MongoDbTailingThread(this.endpoint, this, trackingManager);
        this.tailingThread.init();
        this.executor.execute(this.tailingThread);
    }

    protected MongoDbTailTrackingManager initTailTracking() {
        MongoDbTailTrackingManager answer = new MongoDbTailTrackingManager(this.endpoint.getMongoConnection(), this.endpoint.getTailTrackingConfig());
        answer.initialize();
        return answer;
    }
}

