/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.converters;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.bson.BsonArray;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class MongoDbBasicConverters {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasicConverters.class);
    private static final DocumentCodec DOCUMENT_CODEC = new DocumentCodec();
    private static final DecoderContext DECODER_CONTEXT = DecoderContext.builder().build();

    private MongoDbBasicConverters() {
    }

    @Converter
    public static Document fromMapToDocument(Map<String, Object> map) {
        return new Document(map);
    }

    @Converter
    public static Map<String, Object> fromDocumentToMap(Document document) {
        return document;
    }

    @Converter
    public static Document fromStringToDocument(String s) {
        return Document.parse(s);
    }

    @Converter
    public static Bson fromStringToBson(String s) {
        return Document.parse(s);
    }

    @Converter
    public static ObjectId fromStringToObjectId(String s) {
        return new ObjectId(s);
    }

    @Converter
    public static Document fromFileToDocument(File f, Exchange exchange) throws Exception {
        return MongoDbBasicConverters.fromInputStreamToDocument(new FileInputStream(f), exchange);
    }

    @Converter
    public static Document fromByteArrayToDocument(byte[] data, Exchange exchange) throws Exception {
        Document answer;
        String input = new String(data, ExchangeHelper.getCharsetName(exchange));
        if (MongoDbBasicConverters.isBson(data)) {
            JsonReader reader = new JsonReader(input);
            answer = DOCUMENT_CODEC.decode(reader, DECODER_CONTEXT);
        } else {
            answer = Document.parse(input);
        }
        return answer;
    }

    @Converter
    public static Bson fromInputStreamToBson(InputStream is, Exchange exchange) throws Exception {
        return MongoDbBasicConverters.fromInputStreamToDocument(is, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static Document fromInputStreamToDocument(InputStream is, Exchange exchange) throws Exception {
        Document answer = null;
        try {
            byte[] input = IOConverter.toBytes(is);
            if (MongoDbBasicConverters.isBson(input)) {
                JsonReader reader = new JsonReader(new String(input));
                DocumentCodec documentReader = new DocumentCodec();
                answer = documentReader.decode(reader, DecoderContext.builder().build());
            } else {
                answer = Document.parse(IOConverter.toString(input, exchange));
            }
        }
        finally {
            IOHelper.close((Closeable)is, "InputStream", LOG);
        }
        return answer;
    }

    private static boolean isBson(byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == 123) {
                return false;
            }
            if (Character.isWhitespace(input[i])) continue;
            return true;
        }
        return true;
    }

    @Converter(allowNull=true)
    public static List<Bson> fromStringToList(String value) {
        if (!MongoDbBasicConverters.isArrayNotation(value)) {
            return null;
        }
        CodecRegistry codecRegistry = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider()));
        JsonReader reader = new JsonReader(value);
        BsonArrayCodec arrayReader = new BsonArrayCodec(codecRegistry);
        BsonArray docArray = arrayReader.decode(reader, DecoderContext.builder().build());
        ArrayList<Bson> answer = new ArrayList<Bson>(docArray.size());
        for (BsonValue doc : docArray) {
            answer.add(doc.asDocument());
        }
        return answer;
    }

    private static boolean isArrayNotation(String value) {
        return value != null && !value.isEmpty() && value.length() > 1 && value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']';
    }
}

