/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.ServerCursor;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.operation.CommandCursorResult;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;

final class CommandBatchCursorHelper {
    static final String FIRST_BATCH = "firstBatch";
    static final String NEXT_BATCH = "nextBatch";
    static final FieldNameValidator NO_OP_FIELD_NAME_VALIDATOR = new NoOpFieldNameValidator();
    static final String MESSAGE_IF_CLOSED_AS_CURSOR = "Cursor has been closed";
    static final String MESSAGE_IF_CLOSED_AS_ITERATOR = "Iterator has been closed";
    static final String MESSAGE_IF_CONCURRENT_OPERATION = "Another operation is currently in progress, concurrent operations are not supported";

    static BsonDocument getMoreCommandDocument(long cursorId, ConnectionDescription connectionDescription, MongoNamespace namespace, int batchSize, long maxTimeMS, @Nullable BsonValue comment) {
        BsonDocument document = new BsonDocument("getMore", new BsonInt64(cursorId)).append("collection", new BsonString(namespace.getCollectionName()));
        if (batchSize != 0) {
            document.append("batchSize", new BsonInt32(batchSize));
        }
        if (maxTimeMS != 0L) {
            document.append("maxTimeMS", new BsonInt64(maxTimeMS));
        }
        if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
            DocumentHelper.putIfNotNull(document, "comment", comment);
        }
        return document;
    }

    static <T> CommandCursorResult<T> logCommandCursorResult(CommandCursorResult<T> commandCursorResult) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Received batch of %d documents with cursorId %d from server %s", commandCursorResult.getResults().size(), commandCursorResult.getCursorId(), commandCursorResult.getServerAddress()));
        }
        return commandCursorResult;
    }

    static BsonDocument getKillCursorsCommand(MongoNamespace namespace, ServerCursor serverCursor) {
        return new BsonDocument("killCursors", new BsonString(namespace.getCollectionName())).append("cursors", new BsonArray(Collections.singletonList(new BsonInt64(serverCursor.getId()))));
    }

    static MongoQueryException translateCommandException(MongoCommandException commandException, ServerCursor cursor) {
        if (commandException.getErrorCode() == 43) {
            return new MongoCursorNotFoundException(cursor.getId(), commandException.getResponse(), cursor.getAddress());
        }
        return new MongoQueryException(commandException.getResponse(), commandException.getServerAddress());
    }

    private CommandBatchCursorHelper() {
    }
}

