/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.gridfs;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.camel.Exchange;
import org.apache.camel.component.mongodb.gridfs.GridFsEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.bson.Document;
import org.bson.types.ObjectId;

public class GridFsProducer
extends DefaultProducer {
    private final GridFsEndpoint endpoint;

    public GridFsProducer(GridFsEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation = this.endpoint.getOperation();
        if (operation == null) {
            operation = exchange.getIn().getHeader("gridfs.operation", String.class);
        }
        if (operation == null || "create".equals(operation)) {
            String ct;
            Document document;
            String metaData;
            String filename = exchange.getIn().getHeader("CamelFileName", String.class);
            Integer chunkSize = exchange.getIn().getHeader("gridfs.chunksize", Integer.class);
            GridFSUploadOptions options = new GridFSUploadOptions();
            if (chunkSize != null && chunkSize > 0) {
                options.chunkSizeBytes(chunkSize);
            }
            if ((metaData = exchange.getIn().getHeader("gridfs.metadata", String.class)) != null && (document = Document.parse(metaData)) != null) {
                options.metadata(document);
            }
            if ((ct = exchange.getIn().getHeader("Content-Type", String.class)) != null) {
                Document metadata = options.getMetadata();
                if (metadata == null) {
                    metadata = new Document();
                    options.metadata(metadata);
                }
                metadata.put("contentType", (Object)ct);
            }
            InputStream ins = exchange.getIn().getMandatoryBody(InputStream.class);
            ObjectId objectId = this.endpoint.getGridFsBucket().uploadFromStream(filename, ins, options);
            exchange.getIn().setHeader("CamelFileNameProduced", filename);
            exchange.getIn().setHeader("gridfs.fileid", objectId);
            exchange.getIn().setHeader("gridfs.objectid", objectId);
        } else if ("remove".equals(operation)) {
            ObjectId objectId = exchange.getIn().getHeader("gridfs.objectid", ObjectId.class);
            if (objectId != null) {
                this.endpoint.getGridFsBucket().delete(objectId);
            } else {
                String filename = exchange.getIn().getHeader("CamelFileName", String.class);
                GridFSFile file = (GridFSFile)this.endpoint.getGridFsBucket().find(Filters.eq("filename", filename)).first();
                if (file != null) {
                    this.endpoint.getGridFsBucket().delete(file.getId());
                }
            }
        } else if ("findOne".equals(operation)) {
            String filename = exchange.getIn().getHeader("CamelFileName", String.class);
            GridFSDownloadStream downloadStream = this.endpoint.getGridFsBucket().openDownloadStream(filename);
            GridFSFile file = downloadStream.getGridFSFile();
            Document metadata = file.getMetadata();
            if (metadata != null) {
                exchange.getIn().setHeader("gridfs.metadata", metadata.toJson());
                Object contentType = metadata.get("contentType");
                if (contentType != null) {
                    exchange.getIn().setHeader("CamelFileContentType", contentType);
                }
            }
            exchange.getIn().setHeader("CamelFileLength", file.getLength());
            exchange.getIn().setHeader("CamelFileLastModified", file.getUploadDate());
            exchange.getIn().setBody(downloadStream, InputStream.class);
        } else if ("listAll".equals(operation)) {
            String filename = exchange.getIn().getHeader("CamelFileName", String.class);
            MongoCursor<GridFSFile> cursor = filename == null ? this.endpoint.getGridFsBucket().find().cursor() : this.endpoint.getGridFsBucket().find(Filters.eq("filename", filename)).cursor();
            exchange.getIn().setBody(new DBCursorFilenameReader(cursor), Reader.class);
        } else if ("count".equals(operation)) {
            String filename = exchange.getIn().getHeader("CamelFileName", String.class);
            long count = filename == null ? this.endpoint.getFilesCollection().countDocuments() : this.endpoint.getFilesCollection().countDocuments(Filters.eq("filename", filename));
            exchange.getIn().setBody(count, Long.class);
        }
    }

    private static class DBCursorFilenameReader
    extends Reader {
        MongoCursor<GridFSFile> cursor;
        StringBuilder current;
        int pos;

        DBCursorFilenameReader(MongoCursor<GridFSFile> c) {
            this.cursor = c;
            this.current = new StringBuilder(4096);
            this.pos = 0;
            this.fill();
        }

        void fill() {
            if (this.pos > 0) {
                this.current.delete(0, this.pos);
                this.pos = 0;
            }
            while (this.cursor.hasNext() && this.current.length() < 4000) {
                GridFSFile file = this.cursor.next();
                this.current.append(file.getFilename()).append("\t").append(file.getId()).append("\n");
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.pos == this.current.length()) {
                this.fill();
            }
            if (this.pos == this.current.length()) {
                return -1;
            }
            if (len > this.current.length() - this.pos) {
                len = this.current.length() - this.pos;
            }
            this.current.getChars(this.pos, this.pos + len, cbuf, off);
            this.pos += len;
            return len;
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }
}

