/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mvel;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mvel.MvelEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="mvel")
public class MvelComponent
extends DefaultComponent {
    @Metadata(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @Metadata(defaultValue="false")
    private boolean allowContextMapAll;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        MvelEndpoint answer = new MvelEndpoint(uri, this, remaining);
        answer.setContentCache(cache);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        answer.setAllowContextMapAll(this.allowContextMapAll);
        this.setProperties(answer, parameters);
        if (ResourceHelper.isHttpUri(remaining)) {
            remaining = ResourceHelper.appendParameters(remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }
}

