/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class BeanHelper {
    private BeanHelper() {
    }

    public static Class<?> getValidParameterType(String value) {
        if (ObjectHelper.isEmpty(value)) {
            return null;
        }
        if ((value = value.trim()).startsWith("'") && value.endsWith("'")) {
            return String.class;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return String.class;
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.class;
        }
        if (value.equals("null")) {
            return Object.class;
        }
        if (StringHelper.hasStartToken(value, "simple")) {
            return Object.class;
        }
        boolean numeric = true;
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (i == 0 && ch == '-' || Character.isDigit(ch)) continue;
            numeric = false;
            break;
        }
        if (numeric) {
            return Number.class;
        }
        return null;
    }

    public static boolean isValidParameterValue(String value) {
        if (ObjectHelper.isEmpty(value)) {
            return true;
        }
        return BeanHelper.getValidParameterType(value) != null;
    }

    public static Boolean isAssignableToExpectedType(ClassResolver resolver, String parameterType, Class<?> expectedType) {
        if (parameterType == null || !parameterType.contains(".class")) {
            return null;
        }
        if (parameterType.contains(" ")) {
            parameterType = StringHelper.before(parameterType, " ");
        }
        if (!parameterType.endsWith(".class")) {
            return null;
        }
        Class<?> parameterClass = resolver.resolveClass(parameterType = parameterType.substring(0, parameterType.length() - 6));
        if (parameterClass == null && parameterType.equals(expectedType.getSimpleName())) {
            return true;
        }
        if (parameterClass == null) {
            return null;
        }
        return parameterClass.isAssignableFrom(expectedType);
    }
}

