/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.support.LRUCacheFactory;

public class MethodInfoCache {
    private final CamelContext camelContext;
    private final Map<Method, MethodInfo> methodCache;
    private final Map<Class<?>, BeanInfo> classCache;

    public MethodInfoCache(CamelContext camelContext) {
        this(camelContext, 1000, 10000);
    }

    public MethodInfoCache(CamelContext camelContext, int classCacheSize, int methodCacheSize) {
        this(camelContext, MethodInfoCache.createClassCache(classCacheSize), MethodInfoCache.createMethodCache(methodCacheSize));
    }

    public MethodInfoCache(CamelContext camelContext, Map<Class<?>, BeanInfo> classCache, Map<Method, MethodInfo> methodCache) {
        this.camelContext = camelContext;
        this.classCache = classCache;
        this.methodCache = methodCache;
    }

    public MethodInfo getMethodInfo(Method method) {
        return this.methodCache.computeIfAbsent(method, this::createMethodInfo);
    }

    protected MethodInfo createMethodInfo(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        BeanInfo info = this.getBeanInfo(declaringClass);
        return info.getMethodInfo(method);
    }

    protected BeanInfo getBeanInfo(Class<?> declaringClass) {
        return this.classCache.computeIfAbsent(declaringClass, this::createBeanInfo);
    }

    protected BeanInfo createBeanInfo(Class<?> declaringClass) {
        return new BeanInfo(this.camelContext, declaringClass);
    }

    protected static <K, V> Map<K, V> createLruCache(int size) {
        return LRUCacheFactory.newLRUSoftCache(size);
    }

    private static Map<Class<?>, BeanInfo> createClassCache(int size) {
        return MethodInfoCache.createLruCache(size);
    }

    private static Map<Method, MethodInfo> createMethodCache(int size) {
        return MethodInfoCache.createLruCache(size);
    }
}

