/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.ObjectHelper;

public class ParameterBindingException
extends RuntimeCamelException {
    private final Method method;
    private final int index;
    private final Class<?> parameterType;
    private final Object parameterValue;

    public ParameterBindingException(Throwable cause, Method method, int index, Class<?> parameterType, Object parameterValue) {
        super(ParameterBindingException.createMessage(method, index, parameterType, parameterValue), cause);
        this.method = method;
        this.index = index;
        this.parameterType = parameterType;
        this.parameterValue = parameterValue;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public Object getParameterValue() {
        return this.parameterValue;
    }

    private static String createMessage(Method method, int index, Class<?> parameterType, Object parameterValue) {
        return "Error during parameter binding on method: " + String.valueOf(method) + " at parameter #" + index + " with type: " + String.valueOf(parameterType) + " with value type: " + String.valueOf(ObjectHelper.type(parameterValue)) + " and value: " + String.valueOf(parameterValue);
    }
}

