/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.ParameterMappingStrategyHelper;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@Language(value="bean")
public class BeanLanguage
extends TypedLanguageSupport
implements ScriptingLanguage,
PropertyConfigurer,
StaticService {
    public static final String LANGUAGE = "bean";
    private volatile BeanComponent beanComponent;
    private volatile ParameterMappingStrategy parameterMappingStrategy;
    private volatile org.apache.camel.spi.Language simple;
    private boolean validate = true;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "validate": {
                this.setValidate(PropertyConfigurerSupport.property(camelContext, Boolean.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression, properties));
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        String ref;
        Class beanType;
        BeanExpression answer = null;
        Object bean = this.property(Object.class, properties, 1, null);
        String method = this.property(String.class, properties, 2, null);
        if (bean != null) {
            answer = new BeanExpression(bean, method);
        }
        if (answer == null && (beanType = this.property(Class.class, properties, 3, null)) != null) {
            answer = new BeanExpression(beanType, method);
        }
        if (answer == null && (ref = this.property(String.class, properties, 4, null)) != null) {
            answer = new BeanExpression(ref, method);
        }
        if (answer == null) {
            answer = this.createBeanExpression(expression);
        }
        if (answer == null) {
            throw new IllegalArgumentException("Bean language requires bean, beanType, or ref argument");
        }
        Object scope = this.property(Object.class, properties, 5, null);
        if (scope instanceof BeanScope) {
            answer.setScope((BeanScope)((Object)scope));
        } else if (scope != null) {
            answer.setScope(BeanScope.valueOf(scope.toString()));
        }
        answer.setValidate(this.property(Boolean.TYPE, properties, 6, this.isValidate()));
        answer.setResultType(this.property(Class.class, properties, 0, null));
        answer.setBeanComponent(this.beanComponent);
        answer.setParameterMappingStrategy(this.parameterMappingStrategy);
        answer.setSimple(this.simple);
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }

    protected BeanExpression createBeanExpression(String expression) {
        BeanExpression answer;
        String beanName = expression;
        String method = null;
        String beanScope = null;
        if (expression.contains("?method=") || expression.contains("?scope=")) {
            beanName = StringHelper.before(expression, "?");
            String query = StringHelper.after(expression, "?");
            try {
                Map<String, Object> map = URISupport.parseQuery(query);
                method = (String)map.get("method");
                beanScope = (String)map.get("scope");
            }
            catch (URISyntaxException e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        } else {
            int doubleColonIndex = expression.indexOf("::");
            int beginOfParameterDeclaration = expression.indexOf(40);
            if (!(doubleColonIndex <= 0 || expression.contains("(") && doubleColonIndex >= beginOfParameterDeclaration)) {
                beanName = expression.substring(0, doubleColonIndex);
                method = expression.substring(doubleColonIndex + 2);
            } else {
                int idx = expression.indexOf(46);
                if (idx > 0) {
                    beanName = expression.substring(0, idx);
                    method = expression.substring(idx + 1);
                }
            }
        }
        if (beanName.startsWith("type:")) {
            try {
                Class<?> clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(beanName.substring(5));
                answer = new BeanExpression(clazz, method);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        } else {
            answer = new BeanExpression(beanName, method);
        }
        if (beanScope != null) {
            answer.setScope(BeanScope.valueOf(beanScope));
        }
        return answer;
    }

    @Override
    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        script = this.loadResource(script);
        String beanName = StringHelper.before(script, "?method=");
        String beanMethod = StringHelper.after(script, "?method=");
        try {
            Object out;
            Object[] args;
            boolean match;
            Class<?> clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(beanName);
            BeanInfo bi = new BeanInfo(this.getCamelContext(), clazz);
            ArrayList<MethodInfo> candidates = new ArrayList<MethodInfo>();
            for (MethodInfo methodInfo : bi.getMethods()) {
                if (!methodInfo.getMethod().getName().equals(beanMethod)) continue;
                int size = bindings != null ? bindings.size() : 0;
                match = methodInfo.getParameters().size() == size;
                if (!match) continue;
                candidates.add(methodInfo);
            }
            if (candidates.isEmpty()) {
                MethodInfo fallback = null;
                for (MethodInfo mi3 : bi.getMethods()) {
                    if (!mi3.getMethod().getName().equals(beanMethod) || !(match = !mi3.hasParameters())) continue;
                    if (fallback == null) {
                        fallback = mi3;
                        continue;
                    }
                    fallback = null;
                    break;
                }
                if (fallback != null) {
                    candidates.add(fallback);
                }
            }
            if (candidates.isEmpty()) {
                throw new MethodNotFoundException(clazz, beanMethod);
            }
            if (candidates.size() > 1) {
                throw new AmbiguousMethodCallException(null, candidates);
            }
            MethodInfo methodInfo = (MethodInfo)candidates.get(0);
            Method method = methodInfo.getMethod();
            Object[] objectArray = args = method.getParameterCount() > 0 && bindings != null ? bindings.values().toArray(new Object[0]) : null;
            if (methodInfo.isStaticMethod()) {
                out = ObjectHelper.invokeMethod(method, null, args);
            } else {
                Object bean = this.getCamelContext().getInjector().newInstance(clazz);
                out = ObjectHelper.invokeMethod(method, bean, args);
            }
            if (out != null && resultType != null) {
                out = this.getCamelContext().getTypeConverter().convertTo(resultType, out);
            }
            return (T)out;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
    }

    @Override
    public void start() {
        this.beanComponent = this.getCamelContext().getComponent(LANGUAGE, BeanComponent.class);
        this.parameterMappingStrategy = ParameterMappingStrategyHelper.createParameterMappingStrategy(this.getCamelContext());
        this.simple = this.getCamelContext().resolveLanguage("simple");
    }

    @Override
    public void stop() {
    }
}

