/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.ResourceResolver;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ResourceResolverSupport;
import org.apache.camel.support.ResourceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceResolver(value="bean")
public class BeanResourceResolver
extends ResourceResolverSupport {
    public static final String SCHEME = "bean";
    private static final Logger LOG = LoggerFactory.getLogger(BeanResourceResolver.class);

    public BeanResourceResolver() {
        super(SCHEME);
    }

    @Override
    public Resource createResource(final String location, final String remaining) {
        LOG.trace("Creating resource from calling bean: {}", (Object)remaining);
        return new ResourceSupport(SCHEME, location){

            @Override
            public boolean exists() {
                return false;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                String text;
                CamelContext context = BeanResourceResolver.this.getCamelContext();
                DefaultExchange dummy = new DefaultExchange(context);
                InputStream answer = null;
                Object out = BeanResourceResolver.this.evaluate(dummy, remaining);
                if (dummy.getException() != null) {
                    throw new IOException("Cannot find resource: " + location + " from calling the bean", dummy.getException());
                }
                if (out != null && (answer = context.getTypeConverter().tryConvertTo(InputStream.class, dummy, out)) == null && (text = context.getTypeConverter().tryConvertTo(String.class, dummy, out)) != null) {
                    answer = new ByteArrayInputStream(text.getBytes());
                }
                if (answer == null) {
                    throw new IOException("Cannot find resource: " + location + " from calling the bean");
                }
                return answer;
            }
        };
    }

    private Object evaluate(Exchange dummy, String expression) {
        return this.getCamelContext().resolveLanguage(SCHEME).createExpression(expression).evaluate(dummy, Object.class);
    }
}

