/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

public class ConstantBeanHolder
implements BeanHolder {
    private final Object bean;
    private final BeanInfo beanInfo;
    private Processor processor;
    private Map<String, Object> options;

    public ConstantBeanHolder(Object bean, BeanInfo beanInfo) {
        ObjectHelper.notNull(bean, "bean");
        ObjectHelper.notNull(beanInfo, "beanInfo");
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public ConstantBeanHolder(Object bean, CamelContext context, ParameterMappingStrategy parameterMappingStrategy, BeanComponent beanComponent) {
        ObjectHelper.notNull(bean, "bean");
        this.bean = bean;
        this.beanInfo = new BeanInfo(context, bean.getClass(), bean, null, parameterMappingStrategy, beanComponent);
    }

    @Override
    public void setErrorHandler(Processor errorHandler) {
        for (MethodInfo mi : this.beanInfo.getMethods()) {
            mi.setErrorHandler(errorHandler);
        }
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        this.options = options;
        if (options != null && !options.isEmpty()) {
            PropertyBindingSupport.build().withRemoveParameters(false).withCamelContext(this.getBeanInfo().getCamelContext()).withProperties(options).withTarget(this.bean).bind();
        }
    }

    public String toString() {
        return ObjectHelper.className(this.bean) + "(" + ObjectHelper.getIdentityHashCode(this.bean) + ")";
    }

    @Override
    public Object getBean(Exchange exchange) {
        return this.bean;
    }

    @Override
    public Processor getProcessor() {
        if (this.processor == null) {
            this.processor = CamelContextHelper.convertTo(this.beanInfo.getCamelContext(), Processor.class, this.bean);
        }
        return this.processor;
    }

    @Override
    public boolean supportProcessor() {
        return true;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public BeanInfo getBeanInfo(Object bean) {
        return null;
    }
}

