/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mybatis.MyBatisEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

@Component(value="mybatis")
public class MyBatisComponent
extends HealthCheckComponent {
    @Metadata(label="advanced", autowired=true)
    private volatile SqlSessionFactory sqlSessionFactory;
    @Metadata(defaultValue="SqlMapConfig.xml", supportFileReference=true)
    private String configurationUri = "SqlMapConfig.xml";

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MyBatisEndpoint answer = new MyBatisEndpoint(uri, this, remaining);
        this.setProperties(answer, parameters);
        return answer;
    }

    protected synchronized SqlSessionFactory createSqlSessionFactory() throws IOException {
        if (this.sqlSessionFactory == null) {
            ObjectHelper.notNull(this.configurationUri, "configurationUri", this);
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), this.configurationUri);
            try {
                this.sqlSessionFactory = new SqlSessionFactoryBuilder().build(is);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return this.sqlSessionFactory;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }
}

