/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.DataPort;
import io.nats.client.impl.IncomingMessageFactory;
import io.nats.client.impl.NatsConnection;
import io.nats.client.support.IncomingHeadersProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

class NatsConnectionReader
implements Runnable {
    private final NatsConnection connection;
    private ByteBuffer protocolBuffer;
    private boolean gotCR;
    private String op;
    private final char[] opArray;
    private int opPos;
    private final char[] msgLineChars;
    private int msgLinePosition;
    private Mode mode;
    private IncomingMessageFactory incoming;
    private byte[] msgHeaders;
    private byte[] msgData;
    private int msgHeadersPosition;
    private int msgDataPosition;
    private final byte[] buffer;
    private int bufferPosition;
    private Future<Boolean> stopped;
    private Future<DataPort> dataPortFuture;
    private DataPort dataPort;
    private final AtomicBoolean running;
    private final boolean utf8Mode;
    private static final int[] TENS = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    NatsConnectionReader(NatsConnection connection) {
        this.connection = connection;
        this.running = new AtomicBoolean(false);
        this.stopped = new CompletableFuture<Boolean>();
        ((CompletableFuture)this.stopped).complete(Boolean.TRUE);
        this.protocolBuffer = ByteBuffer.allocate(this.connection.getOptions().getMaxControlLine());
        this.msgLineChars = new char[this.connection.getOptions().getMaxControlLine()];
        this.opArray = new char[4];
        this.buffer = new byte[connection.getOptions().getBufferSize()];
        this.bufferPosition = 0;
        this.utf8Mode = connection.getOptions().supportUTF8Subjects();
    }

    void start(Future<DataPort> dataPortFuture) {
        this.dataPortFuture = dataPortFuture;
        this.running.set(true);
        this.stopped = this.connection.getExecutor().submit(this, Boolean.TRUE);
    }

    Future<Boolean> stop() {
        return this.stop(true);
    }

    Future<Boolean> stop(boolean shutdownDataPort) {
        if (this.running.get()) {
            this.running.set(false);
            if (shutdownDataPort && this.dataPort != null) {
                try {
                    this.dataPort.shutdownInput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.stopped;
    }

    boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void run() {
        try {
            this.dataPort = this.dataPortFuture.get();
            this.mode = Mode.GATHER_OP;
            this.gotCR = false;
            this.opPos = 0;
            while (this.running.get()) {
                this.bufferPosition = 0;
                int bytesRead = this.dataPort.read(this.buffer, 0, this.buffer.length);
                if (bytesRead > 0) {
                    this.connection.getNatsStatistics().registerRead(bytesRead);
                    while (this.bufferPosition < bytesRead) {
                        if (this.mode == Mode.GATHER_OP) {
                            this.gatherOp(bytesRead);
                        } else if (this.mode == Mode.GATHER_MSG_HMSG_PROTO) {
                            if (this.utf8Mode) {
                                this.gatherProtocol(bytesRead);
                            } else {
                                this.gatherMessageProtocol(bytesRead);
                            }
                        } else if (this.mode == Mode.GATHER_PROTO) {
                            this.gatherProtocol(bytesRead);
                        } else if (this.mode == Mode.GATHER_HEADERS) {
                            this.gatherHeaders(bytesRead);
                        } else {
                            this.gatherMessageData(bytesRead);
                        }
                        if (this.mode != Mode.PARSE_PROTO) continue;
                        this.parseProtocolMessage();
                        this.protocolBuffer.clear();
                    }
                    continue;
                }
                if (bytesRead < 0) {
                    throw new IOException("Read channel closed.");
                }
                this.connection.getNatsStatistics().registerRead(bytesRead);
            }
        }
        catch (IOException io) {
            if (this.running.get()) {
                this.connection.handleCommunicationIssue(io);
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
        }
        finally {
            this.running.set(false);
            this.protocolBuffer.clear();
        }
    }

    void gatherOp(int maxPos) throws IOException {
        try {
            while (this.bufferPosition < maxPos) {
                byte b = this.buffer[this.bufferPosition];
                ++this.bufferPosition;
                if (this.gotCR) {
                    if (b == 10) {
                        this.op = NatsConnectionReader.opFor(this.opArray, this.opPos);
                        this.gotCR = false;
                        this.opPos = 0;
                        this.mode = Mode.PARSE_PROTO;
                        break;
                    }
                    throw new IllegalStateException("Bad socket data, no LF after CR");
                }
                if (b == 32 || b == 9) {
                    this.op = NatsConnectionReader.opFor(this.opArray, this.opPos);
                    this.opPos = 0;
                    if (this.op.equals("MSG") || this.op.equals("HMSG")) {
                        this.msgLinePosition = 0;
                        this.mode = Mode.GATHER_MSG_HMSG_PROTO;
                    } else {
                        this.mode = Mode.GATHER_PROTO;
                    }
                    break;
                }
                if (b == 13) {
                    this.gotCR = true;
                    continue;
                }
                this.opArray[this.opPos] = (char)b;
                ++this.opPos;
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException | NullPointerException | NumberFormatException ex) {
            this.encounteredProtocolError(ex);
        }
    }

    void gatherMessageProtocol(int maxPos) throws IOException {
        try {
            while (this.bufferPosition < maxPos) {
                byte b = this.buffer[this.bufferPosition];
                ++this.bufferPosition;
                if (this.gotCR) {
                    if (b == 10) {
                        this.mode = Mode.PARSE_PROTO;
                        this.gotCR = false;
                        break;
                    }
                    throw new IllegalStateException("Bad socket data, no LF after CR");
                }
                if (b == 13) {
                    this.gotCR = true;
                    continue;
                }
                if (this.msgLinePosition >= this.msgLineChars.length) {
                    throw new IllegalStateException("Protocol line is too long");
                }
                this.msgLineChars[this.msgLinePosition] = (char)b;
                ++this.msgLinePosition;
            }
        }
        catch (IllegalStateException | NullPointerException | NumberFormatException ex) {
            this.encounteredProtocolError(ex);
        }
    }

    void gatherProtocol(int maxPos) throws IOException {
        try {
            while (this.bufferPosition < maxPos) {
                byte b = this.buffer[this.bufferPosition];
                ++this.bufferPosition;
                if (this.gotCR) {
                    if (b == 10) {
                        this.protocolBuffer.flip();
                        this.mode = Mode.PARSE_PROTO;
                        this.gotCR = false;
                        break;
                    }
                    throw new IllegalStateException("Bad socket data, no LF after CR");
                }
                if (b == 13) {
                    this.gotCR = true;
                    continue;
                }
                if (!this.protocolBuffer.hasRemaining()) {
                    this.protocolBuffer = this.connection.enlargeBuffer(this.protocolBuffer);
                }
                this.protocolBuffer.put(b);
            }
        }
        catch (IllegalStateException | NullPointerException | NumberFormatException ex) {
            this.encounteredProtocolError(ex);
        }
    }

    void gatherHeaders(int maxPos) throws IOException {
        try {
            while (this.bufferPosition < maxPos) {
                int possible = maxPos - this.bufferPosition;
                int want = this.msgHeaders.length - this.msgHeadersPosition;
                if (want > 0 && want <= possible) {
                    System.arraycopy(this.buffer, this.bufferPosition, this.msgHeaders, this.msgHeadersPosition, want);
                    this.msgHeadersPosition += want;
                    this.bufferPosition += want;
                    continue;
                }
                if (want > 0) {
                    System.arraycopy(this.buffer, this.bufferPosition, this.msgHeaders, this.msgHeadersPosition, possible);
                    this.msgHeadersPosition += possible;
                    this.bufferPosition += possible;
                    continue;
                }
                if (this.msgHeadersPosition == this.msgHeaders.length) {
                    this.incoming.setHeaders(new IncomingHeadersProcessor(this.msgHeaders));
                    this.msgHeaders = null;
                    this.msgHeadersPosition = -1;
                    this.mode = Mode.GATHER_DATA;
                    break;
                }
                throw new IllegalStateException("Bad socket data, headers do not match expected length");
            }
        }
        catch (IllegalStateException | NullPointerException ex) {
            this.encounteredProtocolError(ex);
        }
    }

    void gatherMessageData(int maxPos) throws IOException {
        try {
            while (this.bufferPosition < maxPos) {
                int possible = maxPos - this.bufferPosition;
                int want = this.msgData.length - this.msgDataPosition;
                if (want > 0 && want <= possible) {
                    System.arraycopy(this.buffer, this.bufferPosition, this.msgData, this.msgDataPosition, want);
                    this.msgDataPosition += want;
                    this.bufferPosition += want;
                    continue;
                }
                if (want > 0) {
                    System.arraycopy(this.buffer, this.bufferPosition, this.msgData, this.msgDataPosition, possible);
                    this.msgDataPosition += possible;
                    this.bufferPosition += possible;
                    continue;
                }
                byte b = this.buffer[this.bufferPosition];
                ++this.bufferPosition;
                if (this.gotCR) {
                    if (b == 10) {
                        this.incoming.setData(this.msgData);
                        this.connection.deliverMessage(this.incoming.getMessage());
                        this.msgData = null;
                        this.msgDataPosition = 0;
                        this.incoming = null;
                        this.gotCR = false;
                        this.op = "UNKNOWN";
                        this.mode = Mode.GATHER_OP;
                        break;
                    }
                    throw new IllegalStateException("Bad socket data, no LF after CR");
                }
                if (b == 13) {
                    this.gotCR = true;
                    continue;
                }
                throw new IllegalStateException("Bad socket data, no CRLF after data");
            }
        }
        catch (IllegalStateException | NullPointerException ex) {
            this.encounteredProtocolError(ex);
        }
    }

    public String grabNextMessageLineElement(int max) {
        if (this.msgLinePosition >= max) {
            return null;
        }
        int start = this.msgLinePosition;
        while (this.msgLinePosition < max) {
            char c = this.msgLineChars[this.msgLinePosition];
            ++this.msgLinePosition;
            if (c != ' ' && c != '\t') continue;
            return new String(this.msgLineChars, start, this.msgLinePosition - start - 1);
        }
        return new String(this.msgLineChars, start, this.msgLinePosition - start);
    }

    static String opFor(char[] chars, int length) {
        if (length == 3) {
            if (!(chars[0] != 'M' && chars[0] != 'm' || chars[1] != 'S' && chars[1] != 's' || chars[2] != 'G' && chars[2] != 'g')) {
                return "MSG";
            }
            if (!(chars[0] != '+' || chars[1] != 'O' && chars[1] != 'o' || chars[2] != 'K' && chars[2] != 'k')) {
                return "+OK";
            }
            return "UNKNOWN";
        }
        if (length == 4) {
            if (!(chars[1] != 'I' && chars[1] != 'i' || chars[0] != 'P' && chars[0] != 'p' || chars[2] != 'N' && chars[2] != 'n' || chars[3] != 'G' && chars[3] != 'g')) {
                return "PING";
            }
            if (!(chars[1] != 'O' && chars[1] != 'o' || chars[0] != 'P' && chars[0] != 'p' || chars[2] != 'N' && chars[2] != 'n' || chars[3] != 'G' && chars[3] != 'g')) {
                return "PONG";
            }
            if (!(chars[0] != '-' || chars[1] != 'E' && chars[1] != 'e' || chars[2] != 'R' && chars[2] != 'r' || chars[3] != 'R' && chars[3] != 'r')) {
                return "-ERR";
            }
            if (!(chars[0] != 'I' && chars[0] != 'i' || chars[1] != 'N' && chars[1] != 'n' || chars[2] != 'F' && chars[2] != 'f' || chars[3] != 'O' && chars[3] != 'o')) {
                return "INFO";
            }
            if (!(chars[0] != 'H' && chars[0] != 'h' || chars[1] != 'M' && chars[1] != 'm' || chars[2] != 'S' && chars[2] != 's' || chars[3] != 'G' && chars[3] != 'g')) {
                return "HMSG";
            }
            return "UNKNOWN";
        }
        return "UNKNOWN";
    }

    public static int parseLength(String s) throws NumberFormatException {
        int length = s.length();
        int retVal = 0;
        if (length > TENS.length) {
            throw new NumberFormatException("Long in message length \"" + s + "\" " + length + " > " + TENS.length);
        }
        for (int i = length - 1; i >= 0; --i) {
            char c = s.charAt(i);
            int d = c - 48;
            if (d > 9) {
                throw new NumberFormatException("Invalid char in message length '" + c + "'");
            }
            retVal += d * TENS[length - i - 1];
        }
        return retVal;
    }

    void parseProtocolMessage() throws IOException {
        try {
            switch (this.op) {
                case "MSG": {
                    int protocolLength = this.msgLinePosition;
                    int protocolLineLength = protocolLength + 4;
                    if (this.utf8Mode) {
                        protocolLineLength = this.protocolBuffer.remaining() + 4;
                        CharBuffer buff = StandardCharsets.UTF_8.decode(this.protocolBuffer);
                        protocolLength = buff.remaining();
                        buff.get(this.msgLineChars, 0, protocolLength);
                    }
                    this.msgLinePosition = 0;
                    String subject = this.grabNextMessageLineElement(protocolLength);
                    String sid = this.grabNextMessageLineElement(protocolLength);
                    String replyTo = this.grabNextMessageLineElement(protocolLength);
                    String lengthChars = null;
                    if (this.msgLinePosition < protocolLength) {
                        lengthChars = this.grabNextMessageLineElement(protocolLength);
                    } else {
                        lengthChars = replyTo;
                        replyTo = null;
                    }
                    if (subject == null || subject.length() == 0 || sid == null || sid.length() == 0 || lengthChars == null) {
                        throw new IllegalStateException("Bad MSG control line, missing required fields");
                    }
                    int incomingLength = NatsConnectionReader.parseLength(lengthChars);
                    this.incoming = new IncomingMessageFactory(sid, subject, replyTo, protocolLineLength, this.utf8Mode);
                    this.mode = Mode.GATHER_DATA;
                    this.msgData = new byte[incomingLength];
                    this.msgDataPosition = 0;
                    this.msgLinePosition = 0;
                    break;
                }
                case "HMSG": {
                    int hProtocolLength = this.msgLinePosition;
                    int hProtocolLineLength = hProtocolLength + 5;
                    if (this.utf8Mode) {
                        hProtocolLineLength = this.protocolBuffer.remaining() + 5;
                        CharBuffer buff = StandardCharsets.UTF_8.decode(this.protocolBuffer);
                        hProtocolLength = buff.remaining();
                        buff.get(this.msgLineChars, 0, hProtocolLength);
                    }
                    this.msgLinePosition = 0;
                    String hSubject = this.grabNextMessageLineElement(hProtocolLength);
                    String hSid = this.grabNextMessageLineElement(hProtocolLength);
                    String replyToOrHdrLen = this.grabNextMessageLineElement(hProtocolLength);
                    String hdrLenOrTotLen = this.grabNextMessageLineElement(hProtocolLength);
                    String hReplyTo = null;
                    int hdrLen = -1;
                    int totLen = -1;
                    if (this.msgLinePosition < hProtocolLength) {
                        hReplyTo = replyToOrHdrLen;
                        hdrLen = NatsConnectionReader.parseLength(hdrLenOrTotLen);
                        totLen = NatsConnectionReader.parseLength(this.grabNextMessageLineElement(hProtocolLength));
                    } else {
                        hdrLen = NatsConnectionReader.parseLength(replyToOrHdrLen);
                        totLen = NatsConnectionReader.parseLength(hdrLenOrTotLen);
                    }
                    if (hSubject == null || hSubject.length() == 0 || hSid == null || hSid.length() == 0) {
                        throw new IllegalStateException("Bad HMSG control line, missing required fields");
                    }
                    this.incoming = new IncomingMessageFactory(hSid, hSubject, hReplyTo, hProtocolLineLength, this.utf8Mode);
                    this.msgHeaders = new byte[hdrLen];
                    this.msgData = new byte[totLen - hdrLen];
                    this.mode = Mode.GATHER_HEADERS;
                    this.msgHeadersPosition = 0;
                    this.msgDataPosition = 0;
                    this.msgLinePosition = 0;
                    break;
                }
                case "+OK": {
                    this.connection.processOK();
                    this.op = "UNKNOWN";
                    this.mode = Mode.GATHER_OP;
                    break;
                }
                case "-ERR": {
                    String errorText = StandardCharsets.UTF_8.decode(this.protocolBuffer).toString().replace("'", "");
                    this.connection.processError(errorText);
                    this.op = "UNKNOWN";
                    this.mode = Mode.GATHER_OP;
                    break;
                }
                case "PING": {
                    this.connection.sendPong();
                    this.op = "UNKNOWN";
                    this.mode = Mode.GATHER_OP;
                    break;
                }
                case "PONG": {
                    this.connection.handlePong();
                    this.op = "UNKNOWN";
                    this.mode = Mode.GATHER_OP;
                    break;
                }
                case "INFO": {
                    String info = StandardCharsets.UTF_8.decode(this.protocolBuffer).toString();
                    this.connection.handleInfo(info);
                    this.op = "UNKNOWN";
                    this.mode = Mode.GATHER_OP;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown protocol operation " + this.op);
                }
            }
        }
        catch (IllegalStateException | NullPointerException | NumberFormatException ex) {
            this.encounteredProtocolError(ex);
        }
    }

    void encounteredProtocolError(Exception ex) throws IOException {
        throw new IOException(ex);
    }

    void fakeReadForTest(byte[] bytes) {
        System.arraycopy(bytes, 0, this.buffer, 0, bytes.length);
        this.bufferPosition = 0;
        this.op = "UNKNOWN";
        this.mode = Mode.GATHER_OP;
    }

    String currentOp() {
        return this.op;
    }

    static enum Mode {
        GATHER_OP,
        GATHER_PROTO,
        GATHER_MSG_HMSG_PROTO,
        PARSE_PROTO,
        GATHER_HEADERS,
        GATHER_DATA;

    }
}

