/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.ByteArrayBuilder;
import io.nats.client.support.Validator;

class NatsPublishableMessage
extends NatsMessage {
    final boolean hasHeaders;

    public NatsPublishableMessage(boolean hasHeaders) {
        this.hasHeaders = hasHeaders;
    }

    public NatsPublishableMessage(String subject, String replyTo, Headers headers, byte[] data, boolean validateSubRep) {
        super(data);
        this.subject = validateSubRep ? Validator.validateSubject(subject, true) : subject;
        String string = this.replyTo = validateSubRep ? Validator.validateReplyTo(replyTo, false) : replyTo;
        if (headers == null || headers.isEmpty()) {
            this.hasHeaders = false;
        } else {
            this.hasHeaders = true;
            headers = headers.isReadOnly() ? headers : new Headers(headers, true, null);
        }
        this.headers = new Headers(headers, false, null);
        this.calculate();
    }

    @Override
    ByteArrayBuilder getProtocolBab() {
        return this.protocolBab;
    }

    @Override
    long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    byte[] getProtocolBytes() {
        return this.protocolBab.toByteArray();
    }

    @Override
    int getControlLineLength() {
        return this.controlLineLength;
    }

    @Override
    int copyNotEmptyHeaders(int destPosition, byte[] dest) {
        if (this.headerLen > 0) {
            return this.headers.serializeToArray(destPosition, dest);
        }
        return 0;
    }
}

