/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class NatsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        NatsEndpoint target = (NatsEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "connection": {
                target.getConfiguration().setConnection(NatsEndpointConfigurer.property(camelContext, Connection.class, value));
                return true;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                target.getConfiguration().setConnectionTimeout(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "credentialsfilepath": 
            case "credentialsFilePath": {
                target.getConfiguration().setCredentialsFilePath(NatsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(NatsEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(NatsEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "flushconnection": 
            case "flushConnection": {
                target.getConfiguration().setFlushConnection(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "flushtimeout": 
            case "flushTimeout": {
                target.getConfiguration().setFlushTimeout(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.getConfiguration().setHeaderFilterStrategy(NatsEndpointConfigurer.property(camelContext, HeaderFilterStrategy.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "maxmessages": 
            case "maxMessages": {
                target.getConfiguration().setMaxMessages(NatsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "maxpingsout": 
            case "maxPingsOut": {
                target.getConfiguration().setMaxPingsOut(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maxreconnectattempts": 
            case "maxReconnectAttempts": {
                target.getConfiguration().setMaxReconnectAttempts(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "noecho": 
            case "noEcho": {
                target.getConfiguration().setNoEcho(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "norandomizeservers": 
            case "noRandomizeServers": {
                target.getConfiguration().setNoRandomizeServers(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "pedantic": {
                target.getConfiguration().setPedantic(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "pinginterval": 
            case "pingInterval": {
                target.getConfiguration().setPingInterval(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "poolsize": 
            case "poolSize": {
                target.getConfiguration().setPoolSize(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "queuename": 
            case "queueName": {
                target.getConfiguration().setQueueName(NatsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "reconnect": {
                target.getConfiguration().setReconnect(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "reconnecttimewait": 
            case "reconnectTimeWait": {
                target.getConfiguration().setReconnectTimeWait(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "replysubject": 
            case "replySubject": {
                target.getConfiguration().setReplySubject(NatsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "replytodisabled": 
            case "replyToDisabled": {
                target.getConfiguration().setReplyToDisabled(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "requestcleanupinterval": 
            case "requestCleanupInterval": {
                target.getConfiguration().setRequestCleanupInterval(NatsEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                target.getConfiguration().setRequestTimeout(NatsEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "secure": {
                target.getConfiguration().setSecure(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "servers": {
                target.getConfiguration().setServers(NatsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                target.getConfiguration().setSslContextParameters(NatsEndpointConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "traceconnection": 
            case "traceConnection": {
                target.getConfiguration().setTraceConnection(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "verbose": {
                target.getConfiguration().setVerbose(NatsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "connection": {
                return Connection.class;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return Integer.TYPE;
            }
            case "credentialsfilepath": 
            case "credentialsFilePath": {
                return String.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "flushconnection": 
            case "flushConnection": {
                return Boolean.TYPE;
            }
            case "flushtimeout": 
            case "flushTimeout": {
                return Integer.TYPE;
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return HeaderFilterStrategy.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxmessages": 
            case "maxMessages": {
                return String.class;
            }
            case "maxpingsout": 
            case "maxPingsOut": {
                return Integer.TYPE;
            }
            case "maxreconnectattempts": 
            case "maxReconnectAttempts": {
                return Integer.TYPE;
            }
            case "noecho": 
            case "noEcho": {
                return Boolean.TYPE;
            }
            case "norandomizeservers": 
            case "noRandomizeServers": {
                return Boolean.TYPE;
            }
            case "pedantic": {
                return Boolean.TYPE;
            }
            case "pinginterval": 
            case "pingInterval": {
                return Integer.TYPE;
            }
            case "poolsize": 
            case "poolSize": {
                return Integer.TYPE;
            }
            case "queuename": 
            case "queueName": {
                return String.class;
            }
            case "reconnect": {
                return Boolean.TYPE;
            }
            case "reconnecttimewait": 
            case "reconnectTimeWait": {
                return Integer.TYPE;
            }
            case "replysubject": 
            case "replySubject": {
                return String.class;
            }
            case "replytodisabled": 
            case "replyToDisabled": {
                return Boolean.TYPE;
            }
            case "requestcleanupinterval": 
            case "requestCleanupInterval": {
                return Integer.TYPE;
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return Long.TYPE;
            }
            case "secure": {
                return Boolean.TYPE;
            }
            case "servers": {
                return String.class;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "traceconnection": 
            case "traceConnection": {
                return Boolean.TYPE;
            }
            case "verbose": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        NatsEndpoint target = (NatsEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "connection": {
                return target.getConfiguration().getConnection();
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return target.getConfiguration().getConnectionTimeout();
            }
            case "credentialsfilepath": 
            case "credentialsFilePath": {
                return target.getConfiguration().getCredentialsFilePath();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "flushconnection": 
            case "flushConnection": {
                return target.getConfiguration().isFlushConnection();
            }
            case "flushtimeout": 
            case "flushTimeout": {
                return target.getConfiguration().getFlushTimeout();
            }
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getConfiguration().getHeaderFilterStrategy();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxmessages": 
            case "maxMessages": {
                return target.getConfiguration().getMaxMessages();
            }
            case "maxpingsout": 
            case "maxPingsOut": {
                return target.getConfiguration().getMaxPingsOut();
            }
            case "maxreconnectattempts": 
            case "maxReconnectAttempts": {
                return target.getConfiguration().getMaxReconnectAttempts();
            }
            case "noecho": 
            case "noEcho": {
                return target.getConfiguration().isNoEcho();
            }
            case "norandomizeservers": 
            case "noRandomizeServers": {
                return target.getConfiguration().isNoRandomizeServers();
            }
            case "pedantic": {
                return target.getConfiguration().isPedantic();
            }
            case "pinginterval": 
            case "pingInterval": {
                return target.getConfiguration().getPingInterval();
            }
            case "poolsize": 
            case "poolSize": {
                return target.getConfiguration().getPoolSize();
            }
            case "queuename": 
            case "queueName": {
                return target.getConfiguration().getQueueName();
            }
            case "reconnect": {
                return target.getConfiguration().isReconnect();
            }
            case "reconnecttimewait": 
            case "reconnectTimeWait": {
                return target.getConfiguration().getReconnectTimeWait();
            }
            case "replysubject": 
            case "replySubject": {
                return target.getConfiguration().getReplySubject();
            }
            case "replytodisabled": 
            case "replyToDisabled": {
                return target.getConfiguration().isReplyToDisabled();
            }
            case "requestcleanupinterval": 
            case "requestCleanupInterval": {
                return target.getConfiguration().getRequestCleanupInterval();
            }
            case "requesttimeout": 
            case "requestTimeout": {
                return target.getConfiguration().getRequestTimeout();
            }
            case "secure": {
                return target.getConfiguration().isSecure();
            }
            case "servers": {
                return target.getConfiguration().getServers();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return target.getConfiguration().getSslContextParameters();
            }
            case "traceconnection": 
            case "traceConnection": {
                return target.getConfiguration().isTraceConnection();
            }
            case "verbose": {
                return target.getConfiguration().isVerbose();
            }
        }
        return null;
    }
}

