/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.metadata;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.extension.MetaDataExtension;

public class DefaultMetaData
implements MetaDataExtension.MetaData {
    private final Map<String, Object> attributes;
    private final Object payload;
    private final CamelContext camelContext;

    public DefaultMetaData(CamelContext camelContext, Map<String, Object> attributes, Object payload) {
        this.camelContext = camelContext;
        this.attributes = attributes;
        this.payload = payload;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public <T> T getAttribute(String name, Class<T> type) {
        Object value = this.attributes.get(name);
        if (this.camelContext != null) {
            return this.camelContext.getTypeConverter().convertTo(type, value);
        }
        throw new IllegalStateException("Unable to perform conversion as CamelContext is not set");
    }

    @Override
    public Object getPayload() {
        return this.payload;
    }

    @Override
    public <T> T getPayload(Class<T> type) {
        if (this.camelContext != null) {
            return this.camelContext.getTypeConverter().convertTo(type, this.payload);
        }
        throw new IllegalStateException("Unable to perform conversion as CamelContext is not set");
    }
}

