/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;

public class BaseConsumeOptions
implements JsonSerializable {
    public static final int DEFAULT_MESSAGE_COUNT = 500;
    public static final int DEFAULT_MESSAGE_COUNT_WHEN_BYTES = 1000000;
    public static final int DEFAULT_THRESHOLD_PERCENT = 25;
    public static final long DEFAULT_EXPIRES_IN_MILLIS = 30000L;
    public static final long MIN_EXPIRES_MILLS = 1000L;
    public static final long MAX_HEARTBEAT_MILLIS = 30000L;
    public static final int MAX_IDLE_HEARTBEAT_PERCENT = 50;
    protected final int messages;
    protected final long bytes;
    protected final long expiresIn;
    protected final long idleHeartbeat;
    protected final int thresholdPercent;
    protected final boolean noWait;

    protected BaseConsumeOptions(Builder b) {
        this.bytes = b.bytes;
        this.messages = this.bytes > 0L ? (b.messages < 0 ? 1000000 : b.messages) : (b.messages < 0 ? 500 : b.messages);
        this.thresholdPercent = b.thresholdPercent;
        this.noWait = b.noWait;
        this.expiresIn = b.expiresIn == -1L && !this.noWait ? 30000L : b.expiresIn;
        this.idleHeartbeat = Math.min(30000L, this.expiresIn * 50L / 100L);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "messages", this.messages);
        JsonUtils.addField(sb, "bytes", this.bytes);
        JsonUtils.addField(sb, "expires_in", this.expiresIn);
        JsonUtils.addField(sb, "idle_heartbeat", this.idleHeartbeat);
        JsonUtils.addField(sb, "threshold_percent", this.thresholdPercent);
        JsonUtils.addFldWhenTrue(sb, "no_wait", this.noWait);
        return JsonUtils.endJson(sb).toString();
    }

    public long getExpiresInMillis() {
        return this.expiresIn;
    }

    public long getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public int getThresholdPercent() {
        return this.thresholdPercent;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    protected static abstract class Builder<B, CO> {
        protected int messages = -1;
        protected long bytes = 0L;
        protected int thresholdPercent = 25;
        protected long expiresIn = 30000L;
        protected boolean noWait = false;

        protected Builder() {
        }

        protected abstract B getThis();

        protected B noWait() {
            return this.getThis();
        }

        public B json(String json) throws JsonParseException {
            return this.jsonValue(JsonParser.parse(json));
        }

        public B jsonValue(JsonValue jsonValue) {
            this.messages(JsonValueUtils.readInteger(jsonValue, "messages", -1));
            this.bytes(JsonValueUtils.readLong(jsonValue, "bytes", -1L));
            this.expiresIn(JsonValueUtils.readLong(jsonValue, "expires_in", 1000L));
            this.thresholdPercent(JsonValueUtils.readInteger(jsonValue, "threshold_percent", -1));
            if (JsonValueUtils.readBoolean(jsonValue, "no_wait", false).booleanValue()) {
                this.noWait();
            }
            return this.getThis();
        }

        protected B messages(int messages) {
            this.messages = messages < 1 ? -1 : messages;
            return this.getThis();
        }

        protected B bytes(long bytes) {
            this.bytes = bytes < 1L ? 0L : bytes;
            return this.getThis();
        }

        public B expiresIn(long expiresInMillis) {
            if (expiresInMillis < 1L) {
                this.expiresIn = -1L;
            } else {
                if (expiresInMillis < 1000L) {
                    throw new IllegalArgumentException("Expires must be greater than or equal to 1000");
                }
                this.expiresIn = expiresInMillis;
            }
            return this.getThis();
        }

        public B thresholdPercent(int thresholdPercent) {
            this.thresholdPercent = thresholdPercent < 1 ? 25 : Math.min(100, thresholdPercent);
            return this.getThis();
        }

        public abstract CO build();
    }
}

