/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Statistics;
import io.nats.client.StatisticsCollector;
import java.text.NumberFormat;
import java.util.LongSummaryStatistics;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

class NatsStatistics
implements Statistics,
StatisticsCollector {
    private final ReentrantLock readStatsLock = new ReentrantLock();
    private final ReentrantLock writeStatsLock = new ReentrantLock();
    private LongSummaryStatistics readStats = new LongSummaryStatistics();
    private LongSummaryStatistics writeStats = new LongSummaryStatistics();
    private AtomicLong flushCounter = new AtomicLong();
    private AtomicLong outstandingRequests = new AtomicLong();
    private AtomicLong requestsSent = new AtomicLong();
    private AtomicLong repliesReceived = new AtomicLong();
    private AtomicLong duplicateRepliesReceived = new AtomicLong();
    private AtomicLong orphanRepliesReceived = new AtomicLong();
    private AtomicLong reconnects = new AtomicLong();
    private AtomicLong inMsgs = new AtomicLong();
    private AtomicLong outMsgs = new AtomicLong();
    private AtomicLong inBytes = new AtomicLong();
    private AtomicLong outBytes = new AtomicLong();
    private AtomicLong pingCount = new AtomicLong();
    private AtomicLong okCount = new AtomicLong();
    private AtomicLong errCount = new AtomicLong();
    private AtomicLong exceptionCount = new AtomicLong();
    private AtomicLong droppedCount = new AtomicLong();
    private boolean trackAdvanced;

    @Override
    public void setAdvancedTracking(boolean trackAdvanced) {
        this.trackAdvanced = trackAdvanced;
    }

    @Override
    public void incrementPingCount() {
        this.pingCount.incrementAndGet();
    }

    @Override
    public void incrementDroppedCount() {
        this.droppedCount.incrementAndGet();
    }

    @Override
    public void incrementOkCount() {
        this.okCount.incrementAndGet();
    }

    @Override
    public void incrementErrCount() {
        this.errCount.incrementAndGet();
    }

    @Override
    public void incrementExceptionCount() {
        this.exceptionCount.incrementAndGet();
    }

    @Override
    public void incrementRequestsSent() {
        this.requestsSent.incrementAndGet();
    }

    @Override
    public void incrementRepliesReceived() {
        this.repliesReceived.incrementAndGet();
    }

    @Override
    public void incrementDuplicateRepliesReceived() {
        this.duplicateRepliesReceived.incrementAndGet();
    }

    @Override
    public void incrementOrphanRepliesReceived() {
        this.orphanRepliesReceived.incrementAndGet();
    }

    @Override
    public void incrementReconnects() {
        this.reconnects.incrementAndGet();
    }

    @Override
    public void incrementInMsgs() {
        this.inMsgs.incrementAndGet();
    }

    @Override
    public void incrementOutMsgs() {
        this.outMsgs.incrementAndGet();
    }

    @Override
    public void incrementInBytes(long bytes) {
        this.inBytes.addAndGet(bytes);
    }

    @Override
    public void incrementOutBytes(long bytes) {
        this.outBytes.addAndGet(bytes);
    }

    @Override
    public void incrementFlushCounter() {
        this.flushCounter.incrementAndGet();
    }

    @Override
    public void incrementOutstandingRequests() {
        this.outstandingRequests.incrementAndGet();
    }

    @Override
    public void decrementOutstandingRequests() {
        this.outstandingRequests.decrementAndGet();
    }

    @Override
    public void registerRead(long bytes) {
        if (!this.trackAdvanced) {
            return;
        }
        this.readStatsLock.lock();
        try {
            this.readStats.accept(bytes);
        }
        finally {
            this.readStatsLock.unlock();
        }
    }

    @Override
    public void registerWrite(long bytes) {
        if (!this.trackAdvanced) {
            return;
        }
        this.writeStatsLock.lock();
        try {
            this.writeStats.accept(bytes);
        }
        finally {
            this.writeStatsLock.unlock();
        }
    }

    @Override
    public long getPings() {
        return this.pingCount.get();
    }

    @Override
    public long getDroppedCount() {
        return this.droppedCount.get();
    }

    @Override
    public long getOKs() {
        return this.okCount.get();
    }

    @Override
    public long getErrs() {
        return this.errCount.get();
    }

    @Override
    public long getExceptions() {
        return this.exceptionCount.get();
    }

    @Override
    public long getRequestsSent() {
        return this.requestsSent.get();
    }

    @Override
    public long getReconnects() {
        return this.reconnects.get();
    }

    @Override
    public long getInMsgs() {
        return this.inMsgs.get();
    }

    @Override
    public long getOutMsgs() {
        return this.outMsgs.get();
    }

    @Override
    public long getInBytes() {
        return this.inBytes.get();
    }

    @Override
    public long getOutBytes() {
        return this.outBytes.get();
    }

    @Override
    public long getFlushCounter() {
        return this.flushCounter.get();
    }

    @Override
    public long getOutstandingRequests() {
        return this.outstandingRequests.get();
    }

    @Override
    public long getRepliesReceived() {
        return this.repliesReceived.get();
    }

    @Override
    public long getDuplicateRepliesReceived() {
        return this.duplicateRepliesReceived.get();
    }

    @Override
    public long getOrphanRepliesReceived() {
        return this.orphanRepliesReceived.get();
    }

    void appendNumberStat(StringBuilder builder, String name, long value) {
        builder.append(name);
        builder.append(NumberFormat.getNumberInstance().format(value));
        builder.append("\n");
    }

    void appendNumberStat(StringBuilder builder, String name, double value) {
        builder.append(name);
        builder.append(NumberFormat.getNumberInstance().format(value));
        builder.append("\n");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("### Connection ###\n");
        this.appendNumberStat(builder, "Reconnects:                      ", this.reconnects.get());
        this.appendNumberStat(builder, "Requests Sent:                   ", this.requestsSent.get());
        this.appendNumberStat(builder, "Replies Received:                ", this.repliesReceived.get());
        if (this.trackAdvanced) {
            this.appendNumberStat(builder, "Duplicate Replies Received:      ", this.duplicateRepliesReceived.get());
            this.appendNumberStat(builder, "Orphan Replies Received:         ", this.orphanRepliesReceived.get());
        }
        this.appendNumberStat(builder, "Pings Sent:                      ", this.pingCount.get());
        this.appendNumberStat(builder, "+OKs Received:                   ", this.okCount.get());
        this.appendNumberStat(builder, "-Errs Received:                  ", this.errCount.get());
        this.appendNumberStat(builder, "Handled Exceptions:              ", this.exceptionCount.get());
        this.appendNumberStat(builder, "Successful Flush Calls:          ", this.flushCounter.get());
        this.appendNumberStat(builder, "Outstanding Request Futures:     ", this.outstandingRequests.get());
        this.appendNumberStat(builder, "Dropped Messages:                ", this.droppedCount.get());
        builder.append("\n");
        builder.append("### Reader ###\n");
        this.appendNumberStat(builder, "Messages in:                     ", this.inMsgs.get());
        this.appendNumberStat(builder, "Bytes in:                        ", this.inBytes.get());
        builder.append("\n");
        if (this.trackAdvanced) {
            this.readStatsLock.lock();
            try {
                this.appendNumberStat(builder, "Socket Reads:                    ", this.readStats.getCount());
                this.appendNumberStat(builder, "Average Bytes Per Read:          ", this.readStats.getAverage());
                this.appendNumberStat(builder, "Min Bytes Per Read:              ", this.readStats.getMin());
                this.appendNumberStat(builder, "Max Bytes Per Read:              ", this.readStats.getMax());
            }
            finally {
                this.readStatsLock.unlock();
            }
        }
        builder.append("\n");
        builder.append("### Writer ###\n");
        this.appendNumberStat(builder, "Messages out:                    ", this.outMsgs.get());
        this.appendNumberStat(builder, "Bytes out:                       ", this.outBytes.get());
        builder.append("\n");
        if (this.trackAdvanced) {
            this.writeStatsLock.lock();
            try {
                this.appendNumberStat(builder, "Socket Writes:                   ", this.writeStats.getCount());
                this.appendNumberStat(builder, "Average Bytes Per Write:         ", this.writeStats.getAverage());
                this.appendNumberStat(builder, "Min Bytes Per Write:             ", this.writeStats.getMin());
                this.appendNumberStat(builder, "Max Bytes Per Write:             ", this.writeStats.getMax());
            }
            finally {
                this.writeStatsLock.unlock();
            }
        }
        return builder.toString();
    }
}

