/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.RandomUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLUtils {
    public static final String DEFAULT_TLS_ALGORITHM = "SunX509";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static TrustManagerDelegate TRUST_MANAGER_DELEGATE;
    private static final TrustManager[] DEFAULT_TRUST_MANAGERS;

    public static void setDefaultTrustManagerDelegate(TrustManagerDelegate trustManagerDelegate) {
        TRUST_MANAGER_DELEGATE = trustManagerDelegate;
    }

    public static SSLContext createOpenTLSContext() {
        try {
            return SSLUtils.createTrustAllTlsContext();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static SSLContext createTrustAllTlsContext() throws GeneralSecurityException {
        SSLContext context = SSLContext.getInstance("TLSv1.2");
        context.init(null, DEFAULT_TRUST_MANAGERS, RandomUtils.SRAND);
        return context;
    }

    public static KeyStore loadKeystore(String keystorePath, char[] keystorePwd) throws GeneralSecurityException, IOException {
        KeyStore store = KeyStore.getInstance(DEFAULT_KEYSTORE_TYPE);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(keystorePath, new String[0]), new OpenOption[0]));){
            store.load(in, keystorePwd);
        }
        return store;
    }

    public static KeyManager[] createKeyManagers(String keystorePath, char[] keystorePwd) throws GeneralSecurityException, IOException {
        return SSLUtils.createKeyManagers(keystorePath, keystorePwd, DEFAULT_TLS_ALGORITHM);
    }

    public static KeyManager[] createKeyManagers(String keystorePath, char[] keystorePwd, String tlsAlgo) throws GeneralSecurityException, IOException {
        if (keystorePath == null) {
            return null;
        }
        KeyStore store = SSLUtils.loadKeystore(keystorePath, keystorePwd);
        KeyManagerFactory factory = KeyManagerFactory.getInstance(tlsAlgo);
        factory.init(store, keystorePwd);
        return factory.getKeyManagers();
    }

    public static TrustManager[] createTrustManagers(String truststorePath, char[] truststorePwd) throws GeneralSecurityException, IOException {
        return SSLUtils.createTrustManagers(truststorePath, truststorePwd, DEFAULT_TLS_ALGORITHM);
    }

    public static TrustManager[] createTrustManagers(String truststorePath, char[] truststorePwd, String tlsAlgo) throws GeneralSecurityException, IOException {
        if (truststorePath == null) {
            return null;
        }
        KeyStore store = SSLUtils.loadKeystore(truststorePath, truststorePwd);
        TrustManagerFactory factory = TrustManagerFactory.getInstance(tlsAlgo);
        factory.init(store);
        return factory.getTrustManagers();
    }

    public static SSLContext createSSLContext(String keystorePath, char[] keystorePwd, String truststorePath, char[] truststorePwd) throws GeneralSecurityException, IOException {
        return SSLUtils.createSSLContext(keystorePath, keystorePwd, truststorePath, truststorePwd, DEFAULT_TLS_ALGORITHM);
    }

    public static SSLContext createSSLContext(String keystorePath, char[] keystorePwd, String truststorePath, char[] truststorePwd, String tlsAlgo) throws GeneralSecurityException, IOException {
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(SSLUtils.createKeyManagers(keystorePath, keystorePwd, tlsAlgo), SSLUtils.createTrustManagers(truststorePath, truststorePwd, tlsAlgo), RandomUtils.SRAND);
        return ctx;
    }

    static {
        DEFAULT_TRUST_MANAGERS = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return TRUST_MANAGER_DELEGATE == null ? null : TRUST_MANAGER_DELEGATE.getAcceptedIssuers();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                if (TRUST_MANAGER_DELEGATE != null) {
                    TRUST_MANAGER_DELEGATE.checkClientTrusted(certs, authType);
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                if (TRUST_MANAGER_DELEGATE != null) {
                    TRUST_MANAGER_DELEGATE.checkServerTrusted(certs, authType);
                }
            }
        }};
    }

    public static interface TrustManagerDelegate {
        public X509Certificate[] getAcceptedIssuers();

        public void checkClientTrusted(X509Certificate[] var1, String var2);

        public void checkServerTrusted(X509Certificate[] var1, String var2);
    }
}

