/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.nats.NatsComponent;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsConstants;
import org.apache.camel.component.nats.NatsConsumer;
import org.apache.camel.component.nats.NatsProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.17.0", scheme="nats", title="Nats", syntax="nats:topic", category={Category.MESSAGING}, headersClass=NatsConstants.class)
public class NatsEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport,
HeaderFilterStrategyAware,
EndpointServiceLocation {
    @UriParam
    private NatsConfiguration configuration;

    public NatsEndpoint(String uri, NatsComponent component, NatsConfiguration config) {
        super(uri, component);
        this.configuration = config;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new NatsProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        NatsConsumer consumer = new NatsConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public boolean isMultipleConsumersSupported() {
        return true;
    }

    @Override
    public String getServiceUrl() {
        return this.getConfiguration().getServers();
    }

    @Override
    public String getServiceProtocol() {
        return "nats";
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool(this, "NatsTopic[" + this.configuration.getTopic() + "]", this.configuration.getPoolSize());
    }

    public NatsConfiguration getConfiguration() {
        return this.configuration;
    }

    public Connection getConnection() throws InterruptedException, IllegalArgumentException, GeneralSecurityException, IOException {
        Options.Builder builder = this.getConfiguration().createOptions();
        if (this.getConfiguration().getSslContextParameters() != null && this.getConfiguration().isSecure()) {
            SSLContext sslCtx = this.getConfiguration().getSslContextParameters().createSSLContext(this.getCamelContext());
            builder.sslContext(sslCtx);
        }
        if (ObjectHelper.isNotEmpty(this.getConfiguration().getCredentialsFilePath())) {
            builder.authHandler(Nats.staticCredentials(ResourceHelper.resolveResource(this.getCamelContext(), this.getConfiguration().getCredentialsFilePath()).getInputStream().readAllBytes()));
        }
        Options options = builder.build();
        return Nats.connect(options);
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.getConfiguration().getHeaderFilterStrategy();
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.getConfiguration().setHeaderFilterStrategy(strategy);
    }
}

