/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.Arrays;
import org.bouncycastle.crypto.NativeLoader;
import org.bouncycastle.crypto.prng.EntropySource;

class NativeEntropySource
implements EntropySource {
    private final int size;
    private final int effectiveSize;
    private final boolean useSeedSource;

    public NativeEntropySource(int n) {
        if (n < 1) {
            throw new IllegalStateException("bit size less than 1");
        }
        this.size = (n + 7) / 8;
        if (!NativeLoader.hasNativeService("DRBG") && !NativeLoader.hasNativeService("NRBG")) {
            throw new IllegalStateException("no hardware support for random");
        }
        this.useSeedSource = NativeLoader.hasNativeService("NRBG");
        int n2 = this.modulus();
        this.effectiveSize = (this.size + n2 - 1) / n2 * n2;
    }

    @Override
    public native boolean isPredictionResistant();

    public native int modulus();

    @Override
    public byte[] getEntropy() {
        byte[] byArray = new byte[this.effectiveSize];
        this.seedBuffer(byArray, this.useSeedSource);
        if (this.areAllZeroes(byArray, 0, byArray.length)) {
            throw new IllegalStateException("entropy source return array of len " + byArray.length + " where all elements are 0");
        }
        if (this.size != this.effectiveSize) {
            return Arrays.copyOfRange(byArray, 0, this.size);
        }
        return byArray;
    }

    native void seedBuffer(byte[] var1, boolean var2);

    @Override
    public int entropySize() {
        return this.size * 8;
    }

    public boolean areAllZeroes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 |= byArray[n + i];
        }
        return n3 == 0;
    }
}

